#-h- csedit           680 local 08/09/81 12:00:00
 ## common block for csedit tool
 #  put on a file called 'csedit'
 #  (used only by csedit)
 
 common /csedit/ aq, iq, buf(MAXBUF), lastbf, nlines, line1, line2,
   pat(MAXPAT), prevc, nflag
   integer aq           # end of append queue
   integer iq           # end of insert queue
   integer buf          # buf for commands
   integer lastbf       # next available character in buf
   integer nlines       # number of line number expressions
   integer line1        # line number 1 or index to pattern
   integer line2        # line number 2 or index to pattern
   character pat        # current pattern during compilation
   integer prevc        # index of previous command
   integer nflag        # YES to print result of "p" commands only
#-t- csedit           680 local 08/09/81 12:00:00
#-h-  sedit.r                   24845  ascii   02/03/82  13:32:49
#-h- defns           2484 local 08/09/81 12:00:00
 # include ratdef
define(NLINES,0)        # number of line numbers
define(NEXT,1)          # index of next command
define(LINE1,2)         # line number 1 or index of pattern
define(LINE2,3)         # line number 2 or index of pattern
define(COMMAND,4)       # command
define(LIST,5)          # next command on insert/append list
define(TEXT,6)          # text for insert/append or file name for read
define(APPENDCOM,LETA)  # append command
define(CHANGECOM,LETC)  # change command
define(DELETECOM,LETD)  # delete command
define(INSERTCOM,LETI)  # insert command
define(PRINTCOM,LETP)   # print command
define(READCOM,LETR)    # read command
define(SUBSTCOM,LETS)   # substitute command
# define(SUBSTGFLAG,COMMAND+1) # YES for global replacement
define(SUBSTGFLAG,5)
# define(SUBSTPFLAG,COMMAND+2) # YES for print
define(SUBSTPFLAG,6)
# define(SUBSTPAT,COMMAND+3)   # index of pattern
define(SUBSTPAT,7)
# define(SUBSTNEW,COMMAND+4)   # index of replacement
define(SUBSTNEW,8)
define(WRITECOM,LETW)   # write command
# define(WRITEFD,COMMAND+1)    # file descriptor for opened file or 0
define(WRITEFD,5)
define(EQUALCOM,EQUALS) # print line number command
define(INSERTLIST,1)    # location of list of inserts
# define(FIRSTFREE,APPENDLIST+TEXT)    # first free location in buf
define(FIRSTFREE,12)
define(COMMANDLIST,1)
define(MAXBUF,5000)     # size of command buffer
define(LASTLINE,DOLLAR)
define(OK,YES)          # to be compatible with addset/addstr
define(GLOBAL,LETG)     # for getrhs
define(PRINT,LETP)      # for ckp
define(DITTO,(-3))
# define(APPENDLIST,LIST+1)     # location of list of appends
define(APPENDLIST,6)
define(NOFILE,ERR)
define(PATEND,-77)      # EOS marker for patterns (which may contain
                        # zeroes)
# ------------------------------------------------------------------------
#
# NOTE: The version of sedit distributed by the Software Tools Users
# group had some peculiarities -- it stored characters and integers
# in the same arrays.  On many systems this limited these integers to 8 bits,
# which was not enough.  Also, regular expressions, which are coded
# by 'getpat' into special pattern arrays, may contain zeroes.
# On many systems, EOS is also zero.  Thus these pattern arrays could not be
# properly moved around.  
#
# Thus sedit had to undergo considerable alterations to make it
# work.  This version was donated by Unicorn Systems.
# They claim the code now is not pretty, and should be reworked
# for clarity, but at least it works...
#
# ---------------------------------------------------------------------
#-t- defns           2484 local 08/09/81 12:00:00
#-h- sedit           2835 local 08/09/81 12:00:00
# sedit - stream editor
DRIVER(sedit)
   character arg(MAXLINE), linbuf(MAXLINE)
   integer i, j, nfiles, fd, k
   integer length, getarg, open, getlin
   include csedit
   call query ("usage: sedit [-n] [[-e script | -f sfiles] | script] [files].")
   prevc = COMMANDLIST  # initialize lists
#   buf(COMMANDLIST+NEXT) = 0
   k = COMMANDLIST + NEXT
   buf(k) = 0
   lastbf = FIRSTFREE
   nflag = NO
   nfiles = 0
   i = 1
   if (getarg (i, arg, MAXLINE) == EOF |
       arg(i) == QMARK & arg(2) == EOS)
      call usage
   if (arg(1) == MINUS & (arg(2) == LETN | arg(2) == BIGN)) {
      nflag = YES
      i = i + 1
      }
   for (; getarg(i, arg, MAXLINE) ^= EOF; i = i + 2)
      if (arg(1) == MINUS & (arg(2) == LETF | arg(2) == BIGF)) { # -f filename
         if (getarg(i + 1, arg, MAXLINE) == EOF)
            call usage
         fd = open(arg, READ)
         if (fd == ERR)
            call cant(arg)
         while (getlin(arg, fd) ^= EOF)
            call compil(arg, fd)
         call close(fd)
         }
      else if (arg(1) == MINUS & (arg(2)==LETE | arg(2)==BIGE)) { # -e script
         if (getarg(i + 1, arg, MAXLINE) == EOF)
             call usage
         j = length(arg)
         arg(j+1) = NEWLINE
         arg(j+2) = EOS
         call compil(arg, NOFILE)
         }
      else      # no flags
         break
   if (lastbf == FIRSTFREE) {   # use argument as script
      if (getarg(i, arg, MAXLINE) == EOF)
          call usage
      j = length(arg)
      arg(j+1) = NEWLINE
      arg(j+2) = EOS
      call compil(arg, NOFILE)
      i = i + 1
      }
   linbuf(1) = EOS
   lineno = 0
   call docmds(linbuf, 0)       # do line 0 commands
   for (; getarg(i, arg, MAXLINE) ^= EOF; i = i + 1) {
      if (arg(1) == MINUS & arg(2) == EOS)
         fd = STDIN
      else
         fd = open(arg, READ)
      if (fd == ERR)
         call cant(arg)
      call sed(linbuf, lineno, fd)
      if (fd ^= STDIN)
         call close(fd)
      nfiles = nfiles + 1
      }
   if (nfiles == 0)
      call sed(linbuf, lineno, STDIN)
   if (linbuf(1) ^= EOS) {      # set last line number and do last line
      lineno = lineno + 1
#      for (i = buf(COMMANDLIST+NEXT); i > 0; i = buf(i+NEXT)) {
      k = COMMANDLIST + NEXT
      for (i = buf(k); i > 0; i = buf(i+NEXT)) {
         if (buf(i+LINE1) == -HUGE)
            buf(i+LINE1) = -lineno
         if (buf(i+LINE2) == -HUGE)
            buf(i+LINE2) = -lineno
         if (buf(i+COMMAND) == CHANGECOM) #clean unsatisfied c commands
            {
            if (buf(i+NLINES) == 2)
               buf(i+NLINES) = 1    # insures changed text is output
            if (buf(i+NLINES) == 3 & (buf(i+LINE2) > 0 |
               -buf(i+LINE2) >= lineno))
               buf(i+LINE2) = -lineno
            }
         }
      call docmds(linbuf, lineno)
      }
   DRETURN
   end
#-t- sedit           2835 local 08/09/81 12:00:00
#-h- catsub           484 local 08/09/81 12:00:00
 ## catsub - add replacement text to end of  new. 
    subroutine catsub(lin, from, to, sub, new, k, maxnew) 
    integer addset 
    integer from, i, j, junk, k, maxnew, to 
    character lin(MAXLINE), new(maxnew), sub(MAXPAT) 
  
    for (i = 1; sub(i) != EOS; i = i + 1) 
       if (sub(i) == DITTO) 
          for (j = from; j < to; j = j + 1) 
             junk = addset(lin(j), new, k, maxnew) 
       else 
          junk = addset(sub(i), new, k, maxnew) 
    return 
    end 
#-t- catsub           484 local 08/09/81 12:00:00
#-h- ckp              376 local 08/09/81 12:00:00
# ckp - check for "p" after command
   integer function ckp(lin, i, pflag, status)
   character lin(MAXLINE)
   integer i, j, pflag, status
   character clower
 
   j = i
   if (clower(lin(j)) == PRINT) {
      j = j + 1
      pflag = YES
      }
   else
      pflag = NO
   if (lin(j) == NEWLINE)
      status = OK
   else
      status = ERR
   ckp = status
   return
   end
#-t- ckp              376 local 08/09/81 12:00:00
#-h- compil          3157 local 08/09/81 12:00:00
# compil - "compile" command in lin(i) from file fd, increment i
   subroutine compil(lin, fd)
   character lin(MAXLINE)
   integer fd
   character file(MAXNAME), sub(MAXPAT), c
   integer i, gflag, pflag, status, fdw, j
   integer addi, addis, create, getrhs, getfn, ckp, optpat, dotext,
      getlst, patlen
   integer addpat
   character clower
   include csedit
   status = ERR
   i = 1
   if (getlst(lin, i, status) == ERR) {
      call putlin(lin, ERROUT)
      call error("bad line numbers.")
      }
   call skipbl(lin, i)
   buf(prevc+NEXT) = lastbf     # link in new command
   prevc = lastbf
   status = addi(nlines, buf, lastbf, MAXBUF)
   status = addi(0, buf, lastbf, MAXBUF)
   status = addi(line1, buf, lastbf, MAXBUF)
   status = addi(line2, buf, lastbf, MAXBUF)
                                    #fold commands to lower case
   c = clower(lin(i))
   j = c
   status = addi (j, buf, lastbf, MAXBUF)
   if (clower(lin(i)) == APPENDCOM & lin(i+1) == NEWLINE & fd ^= NOFILE) {
      status = addi(0, buf, lastbf, MAXBUF)
      status = dotext(fd)
      }
   else if (clower(lin(i)) == CHANGECOM & lin(i+1) == NEWLINE & fd ^= NOFILE) {
      status = addi(0, buf, lastbf, MAXBUF)
      status = dotext(fd)
      }
   else if (clower(lin(i)) == DELETECOM & lin(i+1) == NEWLINE)
      status = OK
   else if (clower(lin(i)) == INSERTCOM & lin(i+1) == NEWLINE & fd ^= NOFILE) {
      status = addi(0, buf, lastbf, MAXBUF)
      status = dotext(fd)
      }
   else if (clower(lin(i)) == PRINTCOM & lin(i+1) == NEWLINE)
      status = OK
   else if (clower(lin(i)) == READCOM) {
      status = addi(0, buf, lastbf, MAXBUF)
      status = getfn(lin, i, file)
      if (status == OK) {
         status = addis(file, buf, lastbf, MAXBUF)
         status = addi(EOS, buf, lastbf, MAXBUF)
         }
      }
   else if (clower(lin(i)) == SUBSTCOM) {
      i = i + 1
      if (optpat(lin, i) == OK)
         andif (getrhs(lin, i, sub, gflag) == OK)
            status = ckp(lin, i + 1, pflag, status)
      if (status == OK) {
         status = addi(gflag, buf, lastbf, MAXBUF)
         status = addi(pflag, buf, lastbf, MAXBUF)
         status = addi(lastbf + 2, buf, lastbf, MAXBUF)
         status = addi(lastbf + patlen(pat) + 2, buf, lastbf, MAXBUF)
#         status = addis(pat, buf, lastbf, MAXBUF)
#         status = addi(EOS, buf, lastbf, MAXBUF)
                                # insert pattern (special problem
                                # with the EOS marker)
         status = addpat(pat, buf, lastbf, MAXBUF)
         status = addis(sub, buf, lastbf, MAXBUF)
         status = addi(EOS, buf, lastbf, MAXBUF)
         }
      }
   else if (clower(lin(i)) == WRITECOM) {
      status = getfn(lin, i, file)
      if (status == OK) {
         fdw = create(file, WRITE)
         if (fdw == ERR)
            call cant(file)
         }
      status = addi(fdw, buf, lastbf, MAXBUF)
      }
   else if (clower(lin(i)) == EQUALCOM & lin(i+1) == NEWLINE)
      status = OK
   else
      status = ERR
   if (status ^= OK) {
      call putlin(lin, ERROUT)
      if (lastbf > MAXBUF)
         call error("too many commands.")
      else
         call error("invalid command.")
      }
   return
   end
#-t- compil          3157 local 08/09/81 12:00:00
#-h- docmds          2741 local 08/09/81 12:00:00
# docmds-execute commands in buf on linbuf, which contains line lineno
   subroutine docmds(linbuf, lineno)
   character linbuf(MAXLINE), temp(MAXPAT)
   integer lineno
   integer i, n, j
   integer match
   include csedit
   aq = APPENDLIST      # initialize append and insert queues
   buf(aq+LIST) = 0
   iq = INSERTLIST
   buf(iq+LIST) = 0
   j = COMMANDLIST + NEXT
   for (i = buf(j); i ^= 0; i = buf(i+NEXT)) {
      nlines = buf(i+NLINES)
      line1 = buf(i+LINE1)
      line2 = buf(i+LINE2)
     if (nlines == 0)
         call docom(i, linbuf, lineno)
      else if (nlines == 1) {
         if (-line1 == lineno)
            call docom(i, linbuf, lineno)
         else if (line1 > 0)
                {
#                 andif (match(linbuf, buf(line1)) > 0)
                call gpat (buf(line1), 1, temp, 1)
                if (match(linbuf, temp) > 0)
                    call docom(i, linbuf, lineno)
                }
         }
      else if (nlines == 2) {   # 2 line numbers, searching for line1
         if (-line1 == lineno) {
            buf(i+NLINES) = 3   # found it, change state
            call docom(i, linbuf, lineno)
            }
         else if (line1 > 0)
#                 andif (match(linbuf, buf(line1)) > 0) {
                {
                call gpat (buf(line1), 1, temp, 1)
                if (match(linbuf, temp) > 0) {
                    buf(i+NLINES) = 3
                    call docom(i, linbuf, lineno)
                    }
                }
         }
      else if (nlines == 3) {   # 2 line numbers, searching for line2
         if (line2 <= 0) {
            if (lineno >= -line2)
               buf(i+NLINES) = 2        # found it, change state
            if (lineno <= -line2)
               call docom(i, linbuf, lineno)
            }
         else if (line2 > 0) {
#            if (match(linbuf, buf(line2)) > 0)
             call gpat (buf(line2), 1, temp, 1)
              if (match(linbuf, temp) > 0)
                 buf(i+NLINES) = 2
              call docom(i, linbuf, lineno)
            }
         }
      else
         call error("in docmds: can't happen.")
      if (linbuf(1) == EOS & lineno > 0)
         break
      }
                                           # output inserts
   j = INSERTLIST + LIST
   for (i = buf(j); i > 0; i = buf(i+LIST))
#      call putlin(buf(i+TEXT), STDOUT)
        {
        call icopys (buf(i+TEXT), 1, temp, 1)
        call putlin (temp, STDOUT)
        }
   if (nflag == NO)
      call putlin(linbuf, STDOUT)
                                      # output appends
   j = APPENDLIST + LIST
   for (i = buf(j); i > 0; i = buf(i+LIST))  
      if (buf(i+COMMAND) == READCOM)
         call fcopy(buf(i+TEXT), STDOUT)        # do r command
      else
#         call putlin(buf(i+TEXT), STDOUT)
        {
        call icopys (buf(i+TEXT), 1, temp, 1)
        call putlin (temp, STDOUT)
        }
   return
   end
#-t- docmds          2741 local 08/09/81 12:00:00
#-h- docom           1403 local 08/09/81 12:00:00
# docom - execute a single command at buf(i) on linbuf and lineno
   subroutine docom(i, linbuf, lineno)
   character linbuf(MAXLINE)
   character temp1(MAXLINE), temp2(MAXLINE)
   integer i, lineno
   character cmd
   integer k1, k2, junk
   include csedit
   cmd = buf(i+COMMAND)
   if (cmd == APPENDCOM) {
      buf(aq+LIST) = i
      aq = i
      buf(i+LIST) = 0
      }
   else if (cmd == CHANGECOM) {
      linbuf(1) = EOS
      if (buf(i+NLINES) <= 2) {
         buf(aq+LIST) = i
         aq = i
         buf(i+LIST) = 0
         }
      }
   else if (cmd == DELETECOM)
      linbuf(1) = EOS
   else if (cmd == INSERTCOM) {
      buf(iq+LIST) = i
      iq = i
      buf(i+LIST) = 0
      }
   else if (cmd == PRINTCOM)
      call putlin(linbuf, STDOUT)
   else if (cmd == READCOM) {
      buf(aq+LIST) = i
      aq = i
      buf(i+LIST) = 0
      }
   else if (cmd == SUBSTCOM) {
      k1 = buf(i+SUBSTPAT)
      k2 = buf(i+SUBSTNEW)
        call gpat (buf(k1), 1, temp1, 1)
        call icopys (buf(k2), 1, temp2, 1)
        call subst (linbuf, temp1, temp2,
#      call subst(linbuf, buf(k1), buf(k2),
                buf(i+SUBSTGFLAG), buf(i+SUBSTPFLAG))
      }
   else if (cmd == WRITECOM) {
      if (buf(i+WRITEFD) ^= 0)
         call putlin(linbuf, buf(i+WRITEFD))
      }
   else if (cmd == EQUALCOM) {
      call putdec(lineno, 1)
      call putc(NEWLINE)
      }
   # else ignore command
   return
   end
#-t- docom           1403 local 08/09/81 12:00:00
#-h- dotext           376 local 08/09/81 12:00:00
# dotext - append text in file fd onto buf
   integer function dotext(fd)
   integer fd
   integer getlin, addi, addis
   character lin(MAXLINE)
   include csedit
   while (getlin(lin, fd) ^= EOF) {
      if (lin(1) == PERIOD & lin(2) == NEWLINE)
         break
      junk = addis(lin, buf, lastbf, MAXBUF)
      }
   dotext = addi(EOS, buf, lastbf, MAXBUF)
   return
   end
#-t- dotext           376 local 08/09/81 12:00:00
#-h- getfn            461 local 08/09/81 12:00:00
# getfn - get file name from lin(i)...
   integer function getfn(lin, i, file)
   character lin(MAXLINE), file(MAXLINE)
   integer i, j, k
 
   getfn = ERR
   if (lin(i + 1) == BLANK | lin(i + 1) == TAB) {
      j = i + 2      # get new file name
      call skipbl(lin, j)
      for (k = 1; lin(j) ^= NEWLINE; k = k + 1) {
         file(k) = lin(j)
         j = j + 1
         }
      file(k) = EOS
      if (k > 1)
         getfn = OK
      }
   return
   end
#-t- getfn            461 local 08/09/81 12:00:00
#-h- getlst           505 local 08/09/81 12:00:00
# getlst - get a list of line numbers starting at lin(i), increment i
   integer function getlst(lin, i, status)
   character lin(MAXLINE)
   integer i
   integer status    # ignored
   integer num
   integer getone
   include csedit
 
   nlines = 0
   if (getone(lin, i, num) == EOF)
      return(OK)
   line1 = num
   nlines = nlines + 1
   if (lin(i) ^= COMMA)
      return(OK)
   i = i + 1
   if (getone(lin, i, num) ^= OK)
      return(ERR)
   line2 = num
   nlines = nlines + 1
   return(OK)
   end
#-t- getlst           505 local 08/09/81 12:00:00
#-h- getone          1121 local 08/09/81 12:00:00
# getone - evaluate one line number expression, increment i
   integer function getone(lin, i, num)
   character lin(MAXLINE)
   integer i, istart, num
   integer addpat, ctoi, optpat
   include csedit
 
   getone = OK
   call skipbl(lin, i)
   istart = i
   if (lin(i) >= DIG0 & lin(i) <= DIG9) {
      num = ctoi(lin, i)
      i = i - 1   # move back; to be advanced at the end
      if (num < 0)
         getone = ERR
      num = -num
      }
   else if (lin(i) == LASTLINE)
      num = -HUGE
   else if (lin(i) == SLASH) {
      if (optpat(lin, i) == ERR)   # build the pattern
         getone = ERR
      else if (lin(i) == SLASH) {
         num = lastbf
#         junk = addis(pat, buf, lastbf, MAXBUF)
#         if (addi(EOS, buf, lastbf, MAXBUF) == NO)
                        # insert pattern (special
                        # problem with EOS marker)
        if (addpat(pat, buf, lastbf, MAXBUF) == NO)
            getone = ERR
         }
      }
   else
      getone = EOF
   if (getone == OK)
      i = i + 1   # point at next character to be examined
   call skipbl(lin, i)
   if (i <= istart)
      getone = EOF
   else
      getone = OK
   return
   end
#-t- getone          1121 local 08/09/81 12:00:00
#-h- getrhs           494 local 08/09/81 12:00:00
# getrhs - get substitution string for "s" command
   integer function getrhs(lin, i, sub, gflag)
   character lin(MAXLINE), sub(MAXPAT)
   integer maksub
   character clower
   integer gflag, i
 
   getrhs = ERR
   if (lin(i) == EOS)
      return
   if (lin(i + 1) == EOS)
      return
   i = maksub(lin, i + 1, lin(i), sub)
   if (i == ERR)
      return
   if (clower(lin(i + 1)) == GLOBAL) {
      i = i + 1
      gflag = YES
      }
   else
      gflag = NO
   getrhs = OK
   return
   end
#-t- getrhs           494 local 08/09/81 12:00:00
#-h- optpat           679 local 08/09/81 12:00:00
# optpat - make pattern if specified at lin(i)
   integer function optpat(lin, i)
   character lin(MAXLINE)
   integer makpat
   integer i
   include csedit
 
   if (lin(i) == EOS)
      i = ERR
   else if (lin(i + 1) == EOS)
      i = ERR
   else if (lin(i + 1) == lin(i))   # repeated delimiter
      i = i + 1         # leave existing pattern alone
   else
        {
                                # Patterns with closures (*) can't
                                # be terminated with EOS if EOS is >= 0
        for (j=1; j <= MAXPAT; j=j+1)
                pat(j) = PATEND
        i = makpat(lin, i + 1, lin(i), pat)
        }
   if (pat(1) == EOS)
      i = ERR
   if (i == ERR) {
      pat(1) = EOS
      optpat = ERR
      }
   else
      optpat = OK
   return
   end
#-t- optpat           679 local 08/09/81 12:00:00
#-h- maksub           635 local 08/09/81 12:00:00
 ## maksub - make substitution string in sub 
    integer function maksub(arg, from, delim, sub) 
    character esc 
    character arg(MAXARG), delim, sub(MAXPAT) 
    integer addset 
    integer from, i, j, junk 
  
    j = 1 
    for (i = from; arg(i) != delim & arg(i) != EOS; i = i + 1) 
       if (arg(i) == AND) 
          junk = addset(DITTO, sub, j, MAXPAT) 
       else 
          junk = addset(esc(arg, i), sub, j, MAXPAT) 
    if (arg(i) != delim)   # missing delimiter 
       maksub = ERR 
    else if (addset(EOS, sub, j, MAXPAT) == NO)   # no room 
       maksub = ERR 
    else 
       maksub = i 
    return 
    end 
#-t- maksub           635 local 08/09/81 12:00:00
#-h- sed              818 local 08/09/81 12:00:00
# sed-execute all commands for file fd, use linbuf and increment lineno
   subroutine sed(linbuf, lineno, fd)
   character linbuf(MAXLINE)
   integer lineno, fd
   character buf1(MAXLINE), buf2(MAXLINE)
   integer getlin
   include csedit
   if (getlin(buf1, fd) == EOF)
      return
   if (lineno > 0) {    # do previous last line
      lineno = lineno + 1
      call docmds(linbuf, lineno)
      }
   repeat {
      if (getlin(buf2, fd) == EOF) {    # buf1 contains last line
         call scopy(buf1, 1, linbuf, 1)
         break
         }
      lineno = lineno + 1
      call docmds(buf1, lineno)
      if (getlin(buf1, fd) == EOF) {    # buf2 contains last line
         call scopy(buf2, 1, linbuf, 1)
         break
         }
      lineno = lineno + 1
      call docmds(buf2, lineno)
      }
   return
   end
#-t- sed              818 local 08/09/81 12:00:00
#-h- subst           1001 local 08/09/81 12:00:00
# subst - substitute sub for occurrences of pat in txt
   subroutine subst(txt, pat, sub, gflag, pflag)
   character txt(MAXLINE), pat(ARB), sub(ARB)
   integer gflag, pflag
   character new(MAXLINE)
   integer addset, amatch
   integer j, junk, k, lastm, m, subbed
   integer tagbeg(10), tagend(10)	# not used
 
   j = 1
   subbed = NO
   lastm = 0
   for (k = 1; txt(k) ^= EOS; ) {
      if (gflag == YES | subbed == NO)
         m = amatch(txt, k, pat, tagbeg, tagend)
      else
         m = 0
      if (m > 0 & lastm ^= m) {   # replace matched text
         subbed = YES
         call catsub(txt, k, m, sub, new, j, MAXLINE)
         lastm = m
         }
      if (m == 0 | m == k) {   # no match or null match
         junk = addset(txt(k), new, j, MAXLINE)
         k = k + 1
         }
      else            # skip matched text
         k = m
      }
   if (subbed == YES) {
      if (addset(EOS, new, j, MAXLINE) == NO)
         return
      call scopy(new, 1, txt, 1)
      if (pflag == YES)
         call putlin(txt, STDOUT)
      }
   return
   end
#-t- subst           1001 local 08/09/81 12:00:00
#-h- usage            150 local 08/09/81 12:00:00
# usage - print usage message
  subroutine usage
  call error(_
   "usage: sedit [-n] [[-e script | -f sfiles] | script] [files].")
   return
   end
#-t- usage            150 local 08/09/81 12:00:00
#-h- addi             273 local 08/09/81 12:00:00
 ## addi - put i in set(j) if it fits; increment j
 # similar to 'addset' only works with integers rather than characters
 integer function addi (i, set, j, maxsiz)
 integer i, set(maxsiz), j, maxsiz
 if (j > maxsiz)
        return (NO)
 set(j) = i
 j = j + 1
 return (YES)
 end
#-t- addi             273 local 08/09/81 12:00:00
#-h- addis            308 local 08/09/81 12:00:00
## addis - add character string to integer array(j); increment j
   integer function addis(s, str, j, maxsiz)
   character s(ARB)
   integer str(ARB)
   integer j, maxsiz
   integer i
   for (i = 1; s(i) ^= EOS; i = i + 1)
        {
        if (j > maxsiz)
                return (NO)
        str(j) = s(i)
        j = j + 1
        }
 return (YES)
   end
#-t- addis            308 local 08/09/81 12:00:00
#-h- icopys           267 local 08/09/81 12:00:00
 ## icopys - copy integer string to character string
 subroutine icopys (from, i, to, j)
 integer from(ARB), i, j
 character to(ARB)
 integer k1, k2
 k2 = j
 for (k1 = i; from(k1) != EOS; k1 = k1 + 1)
        {
        to(k2) = from(k1)
        k2 = k2 + 1
        }
 to(k2) = EOS
 return
 end
#-t- icopys           267 local 08/09/81 12:00:00
#-h- gpat             431 local 08/09/81 12:00:00
 ## gpat - copy pattern out of integer array (terminated by PATEND marker)
 # The endoding of patterns may include zero, which is often the EOS marker.
 # Thus a special routine is needed for moving patterns around.
 subroutine gpat (from, i, to, j)
 integer from(ARB), i, j
 character to(ARB)
 integer k1, k2
 k2 = j
 for (k1 = i; from(k1) != PATEND; k1 = k1 + 1)
        {
        to(k2) = from(k1)
        k2 = k2 + 1
        }
 to(k2) = EOS
 return
 end
#-t- gpat             431 local 08/09/81 12:00:00
#-h- addpat           574 local 08/09/81 12:00:00
 ## addpat - add pattern string to integer array (use special PATEND marker)
   integer function addpat (pat, buf, j, maxsiz)
   character pat(ARB)
   integer buf(ARB), j, maxsiz
   integer i, lc
                        # assume pattern array was initially filled
                        # with PATEND markers.  Thus first non-PATEND
                        # character is end of pattern.
   for (lc = MAXPAT; lc > 0; lc = lc -1)
        {
        if (pat(lc) != PATEND)
                break
        }
   if ( (j+lc) > maxsiz)
        return (NO)
                        # copy characters; terminate with PATEND
   for (i = 1; i <= lc+1; i=i+1)
        {
        buf(j) = pat(i)
        j = j + 1
        }
 return (YES)
 end
#-t- addpat           574 local 08/09/81 12:00:00
#-h- patlen           164 local 08/09/81 12:00:00
 ## patlen - get length of pattern
 integer function patlen (pat)
 character pat(ARB)
 for (patlen = 0; pat(patlen+1) != PATEND; patlen=patlen+1)
        ;
 return
 end
#-t- patlen           164 local 08/09/81 12:00:00
#-t-  sedit.r                   24845  ascii   02/03/82  13:32:49
