#-h-  defns                      1052  ascii   04/02/82  16:06:06
# TCS data file keys
define(STATS,"%%s ")                    # statistics
define(VERKEY,"%%d ")                   # key field on history-info lines
define(COMMENT,"%%c ")
define(ENDKEY,"%%T")                    # end of header
define(INSERT,"%%I ")                   # begin "inserted in this version"
define(DELETE,"%%D ")                   # begin "deleted in this version"
define(ENDSEG,"%%E ")                   # end of segment
define(KEYSIZ,5)                        # pts AFTER blank at end of key

define(WEWANT,2)                        # positional info from PARSE
define(VDATE,3)
define(VTIME,4)
define(VUSER,5)
define(THISVER,6)
define(PREVVER,7)
define(MAXVER,100)                      # max number of (direct) ancestors

define(OFF,0)
define(ON,1)

# flow control during DIFF processing
# values for "flag"
define(INHIST, 1)
define(INRVSN, 2)
define(MATCHING, 3)

# simulated "structure" during DIFF tree generation
define(PREV, 0)
define(ALINE, 1)
define(BLINE, 2)
define(CANDSIZ, 3)                      # size of a candidate "struct"

#-t-  defns                      1052  ascii   04/02/82  16:06:06
#-h-  decls                       534  ascii   04/02/82  16:06:06
common /tcs/    ancestry(MAXVER),       # family lineage
        fdhis, fdrev, fdscr,    # file descriptors
        flag,                   # flag during history-file generation
        insert,                 # flag during lineget, init'd by rstget
        myances,                # closest ancestor's "absolute" version number
        maxver,                 # last "absolute" version number
        seekptr(2)              # markl/seek pointer
integer ancestry, fdhis, fdrev, fdscr, flag,
        insert, myances, maxver, seekptr

#-t-  decls                       534  ascii   04/02/82  16:06:06
#-h-  get.r                     21276  ascii   04/02/82  16:06:08
#-h- main            2858  asc  20-jan-82 14:32:35  npg
#-p-
# 
# 
# 
#                               MAIN
# 
#     author: Neil P. Groundwater (ADI)                date: 11-SEP-81
# 
# 
# 
#     Purpose:  Validates calling arguments. Allows user to extract history 
#       info or a version of the file. History info extraction is performed 
#       in MAIN. Copies of versions of the file are retrieved by SETGET and 
#       LINEGET. 
# 
# 
#     Calling convention:   main
# 
#     Global Variables Changed
#       fdhis:  file descriptor of historyfile 
#       fdout:  file descriptor of output file 
# 
# 
#     Modules called by MAIN
#       create
#       error
#       cant
#       putch
#       putlin
#       parse
#       aputlin
#       close
#       scopy
#       setget
#       rstget
#       bmatch
#       clower
#       getarg
#       getlin
#       lineget
#       open
# 
# 
# 
#-p-

DRIVER(get)

include "defns"
include "decls"
define(GET,#)                                   # gets rid of unneeded stuff

integer bmatch, clower, getarg, getlin, open
integer lineget, create

character inbuf(MAXLINE)
character wanted(40)                            # the desired version number
character arg(FILENAMESIZE)
character outfile(FILENAMESIZE)
integer argnum, fdout
integer array(16)
string usage "Usage: get [-h][-rM.N] historyfile [resultfile]"
string vers "*** Version # "
string sverkey VERKEY
string scomment COMMENT

if (getarg(1, arg, FILENAMESIZE) == EOF)
	{
        call putlin(usage, ERROUT)
	call putch (NEWLINE, ERROUT)
	call endst (ERR)
	}
if (arg(1) == QMARK & arg(2) == EOS)
	{
	call putlin(usage, ERROUT)
	call putch (NEWLINE, ERROUT)
	call endst (OK)
	}

argnum = 2
if (arg(1) == MINUS) {                          # look for keys
        argnum = 3                              # for result-filename (later)
        if (clower(arg(2)) == LETH) {
                # just print out the history messages

                if (getarg(2, arg, FILENAMESIZE) == EOF)        # re-use arg
                        call error(usage)
                fdhis = open(arg, READ)
                if (fdhis == ERR)
                        call cant(arg)
                while (getlin(inbuf, fdhis) != EOF) {
                        if (bmatch(inbuf, 1, sverkey) != 0) {
                                call putch(NEWLINE, STDOUT)
                                call putlin(vers, STDOUT)

                                call parse(inbuf, KEYSIZ, array, BLANK)
                                call aputlin(inbuf, array(WEWANT), STDOUT)
                                call putch(BLANK, STDOUT)
                                call aputlin(inbuf, array(VDATE), STDOUT)
                                call putch(BLANK, STDOUT)
                                call aputlin(inbuf, array(VTIME), STDOUT)
                                call putch(BLANK, STDOUT)
                                call aputlin(inbuf, array(VUSER), STDOUT)
                                call putch(NEWLINE, STDOUT)
                        }
                        if (bmatch(inbuf, 1, scomment) != 0) {
                                call aputlin(inbuf, KEYSIZ, STDOUT)
                        }
                }
                call close(fdhis)
                return                          # done
        } else {
                if (clower(arg(2)) == LETR) {
                        call scopy(arg, 3, wanted, 1)   # pick up number or EOS
                        # 2nd argument is historyfile... get filename
                        if (getarg(2, arg, FILENAMESIZE) == EOF)
                                call error(usage)
                } else
                        call error('Illegal keyletter.')
        }
}

# 'arg' has the historyfile name... it will be opened in 'setget'
# check for a resultfile name
if (getarg(argnum, outfile, FILENAMESIZE) != EOF) {     # optional
        fdout = create(outfile, WRITE)
        if (fdout == ERR)
                call cant(outfile)
} else
        fdout = STDOUT          # if no name given, send out to terminal

call setget(arg, wanted)        # opens file 'arg' with file des 'fdhis
call rstget(junk)

# Fetch the text.

while (lineget(inbuf, NO) != EOF)
        call putlin(inbuf, fdout)

call close(fdhis)
end
#-t- main            2858  asc  20-jan-82 14:32:35  npg
#-h- parse           1892  asc  20-jan-82 14:32:36  npg
#-p-
#******************************************************************************
#*
#*
#*                               PARSE
#*
#*    author: Neil P Groundwater                       date: 12-AUG-81
#*
#*
#*
#*    Purpose:  Decompose the "Ad" lines in the history file return the
#*       members of the line via an array of indexes into the original text
#*       line. Replace the delimiter character with EOS characters.
#*
#*
#*    Calling convention:   parse(inbuf, from, outarray, delim)
#*
#*
#*    Formal Parameters
#*       inbuf:  Input string (array)
#*       from:  Starting index in inbuf
#*       outarray:  Returned array of member-offsets in inbuf
#*       delim:  Delimiter character supplied by caller
#*
#*
#*    Modules which call PARSE
#*       main
#*
#*
#*    Description of algorithm:  Move "pointer" across input line and set
#*       outarray with pertinent values.
#*
#*
#******************************************************************************
#-p-
# Subroutine: PARSE(INBUF, FROM, OUTARRAY, DELIMITER)

# Enter the chars from the inbuf,
# break it into its components

# Outarray will contain pointers to the start of each memeber of inbuf
# Convert the delimiters to EOS, in place.
# The string is assumed to be NEWLINE terminated.

define(NULL,0)

subroutine parse(inbuf, from, outarray, delim)
character inbuf(MAXLINE)
integer from                            # start offset in inbuf
integer outarray(16)                    # point to each "token"
character delim

integer ptr

        ptr = from
        while (inbuf(ptr) == delim)     # skip to 1st field
                ptr = ptr+1
        for (i=1; inbuf(ptr) != NEWLINE; i=i+1) {
                outarray(i) = ptr

                # skip thru field
                while ((inbuf(ptr) != delim) & (inbuf(ptr) != NEWLINE))
                        ptr = ptr+1

                # zap and skip delimiters
                while ((inbuf(ptr) == delim) & (inbuf(ptr) != NEWLINE)) {
                        inbuf(ptr) = EOS
                        ptr = ptr+1
                }
        }
        inbuf(ptr) = EOS
        outarray(i) = NULL
return
end

#-t- parse           1892  asc  20-jan-82 14:32:36  npg
#-h- bmatch          1377  asc  20-jan-82 14:32:38  npg
#-p-
#******************************************************************************
#*
#*
#*                               BMATCH
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Pattern match - from Software Tools (p.140) (renamed)
#*
#*
#*    Calling convention:   bmatch(lin, from, pat)
#*
#*
#*    Formal Parameters
#*       lin:  source pattern
#*       from:  index in source pattern at which to start comparison
#*       pat:  pattern to match against
#*
#*
#*    Module Returns:  zero if PAT is not present in LIN index of next char
#*       in LIN after the appearance of PAT
#*
#*
#*    Modules which call BMATCH
#*       main
#*       setget
#*       lineget
#*
#*
#*    Description of algorithm:  Compares PAT with a substring of LIN.
#*       Starts comparison with 1st char of PAT and LIN(FROM). If PAT is
#*       present, the index of the "following" char in LIN is returned,
#*       otherwise returns zero.
#*
#*
#******************************************************************************
#-p-
# bmatch - most basic match, Software Tools p. 140.  (renamed)

integer function bmatch(lin, from, pat)
character lin (MAXLINE), pat(MAXLINE)
integer from, i, j

i = from
for (j=1; pat(j) != EOS; j = j + 1) {
        if (lin(i)!=pat(j)) {
                bmatch = 0
                return          # with no match
        }
        i = i + 1
}
bmatch = i
return
end

#-t- bmatch          1377  asc  20-jan-82 14:32:38  npg
#-h- bmch2           1306  asc  20-jan-82 14:32:39  npg
#-p-
#******************************************************************************
#*
#*
#*                               BMCH2
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Like BMATCH, but LIN must end with the PAT string.
#*
#*
#*    Calling convention:   bmch2(lin, from, pat)
#*
#*
#*    Formal Parameters
#*       lin:  source string
#*       from:  index into LIN. Char at which to begin comparison.
#*       pat:  desired pattern in LIN
#*
#*
#*    Module Returns:  YES if LIN ends with PAT starting at LIN(FROM). NO
#*       otherwise.
#*
#*
#*    Modules called by BMCH2
#*       scopy
#*       equal
#*
#*
#*    Modules which call BMCH2
#*       setget
#*
#*
#*    Description of algorithm:  Like BMATCH, but PAT and LIN must end
#*       alike. Examples: bmch2("abcdef", 4, "def") returns YES.
#*       bmch2("abcdef", 4, "de") returns NO.
#*
#*
#******************************************************************************
#-p-
# bmch2 - basic match, also compares the LENGTH of the args

integer function bmch2(lin, from, pat)
character lin (MAXLINE), pat(MAXLINE)
integer from

integer equal

character temp(MAXLINE)

call scopy(lin, from, temp, 1)          # copy string to temp
return(equal(temp, pat))                # returns YES if exactly equal
end

#-t- bmch2           1306  asc  20-jan-82 14:32:39  npg
#-h- ctoi2            962  asc  20-jan-82 14:32:40  npg
#-p-
#******************************************************************************
#*
#*
#*                               CTOI2
#*
#*    author: Neil P Groundwater                       date: 12-AUG-81
#*
#*
#*
#*    Purpose:  Calls CTOI but allows the caller of CTOI2 to pass a
#*       fixed-value argument.
#*
#*
#*    Calling convention:   ctoi2(buf, fixed)
#*
#*
#*    Formal Parameters
#*       buf:  input string
#*       fixed:  offset in buf to begin conversion. May be a FIXED NUMBER
#*          (like 3).
#*
#*
#*    Module Returns:  An integer value.
#*
#*
#*    Modules called by CTOI2
#*       ctoi
#*
#*
#*    Modules which call CTOI2
#*       lineget
#*
#*
#******************************************************************************
#-p-
# convert character string to integer - allows "constant" index as arg

integer function ctoi2(buf, fixed)
character buf
integer fixed

integer ctoi

integer ptr

ptr = fixed
return(ctoi(buf, ptr))
end
#-t- ctoi2            962  asc  20-jan-82 14:32:40  npg
#-h- setget          3385  asc  20-jan-82 14:32:41  npg
#-p-
#******************************************************************************
#*
#*
#*                               SETGET
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Set up ANCESTRY of the previous version of the file.
#*    Used in conjunction with LINEGET which will return
#*    the next line from the desired version and RSTGET
#*    which puts the file pointer at the start of the
#*    "content" portion of the file in preparation for
#*    a new series of LINEGET calls.
#*
#*
#*    Calling convention:   setget (filename, wanted)
#*
#*
#*    Formal Parameters
#*       filename:  file from which to read data
#*       wanted:  (string) version number desired
#*
#*
#*    Global Variables Changed
#*       ancestry:  the family history of the desired version (array)
#*       seekptr:  the file offset at the end of the header info
#*
#*
#*    Modules called by SETGET
#*       error
#*       putlin
#*       parse
#*       aputlin
#*       putch
#*       note
#*       bmatch
#*       bmch2
#*       ctoi2
#*
#*
#*    Modules which call SETGET
#*       main
#*
#*
#******************************************************************************
#-p-
# subroutine SETGET (FILENAME, WANTED)


subroutine setget (filename, wanted)
character filename(FILENAMESIZE)
character wanted(FILENAMESIZE)

include "decls"

integer bmatch, bmch2, ctoi2, getlin, open       # functions

character inbuf(MAXLINE)
integer array(16)       # holds pointers returned by PARSE
integer i
integer thread, iprev, ithis    # trace family tree

string vers "Version # " 
string sverkey VERKEY
string sendkey ENDKEY

fdhis = open(filename, READ)
if (fdhis == ERR)
        call error("Cannot locate TCS history file.")

for (i=1; i<=MAXVER; i=i+1)                     # initialize
        ancestry(i) = NO
thread = -1                                     # follows back up tree
repeat {
        i = getlin(inbuf, fdhis)
        if (i == EOF)
                call error("Unexpected EOF on history-info scan.")
GET     call putlin(inbuf, fdscr)               # keep it for posterity

        if (bmatch(inbuf, 1, sendkey) != 0)
                call error("Nonexistant revision level requested.")

        # Screen for version-info lines
        if (bmatch(inbuf, 1, sverkey) != 0) {
                call parse(inbuf, KEYSIZ, array, BLANK)
                ithis = ctoi2(inbuf, array(THISVER))    # thread values
                iprev = ctoi2(inbuf, array(PREVVER))

                if (thread < 0) {
                        # When the FIRST version-info line is detected, get
                        #  the "absolute" version number so that it may be
                        #  added later to the family tree.
                        maxver = ithis
                        thread = 0
                }

                if (thread == 0) {                      # started yet?
                        # Was either no version specified or
                        #  is this the requested version?
                        if ((wanted(1) == EOS) | # if none, take latest version
                            (bmch2(inbuf, array(WEWANT), wanted) == YES)) {
                                # yes, start recording ancestry
                                ancestry(ithis) = YES
GET                             myances = ithis         # parent of new stuff
                                thread = iprev          # predecessor
                                # announce version number if user didn't specify
                                if (wanted(1) == EOS) {
                                        call putlin(vers, ERROUT)
                                        call aputlin(inbuf, array(WEWANT), ERROUT)
                                        call putch(NEWLINE, ERROUT)
                                }
                                if (thread == 0)        # reached root
                                        break
                        } else
                                next    # not a match, go on to next info-line
                } else
                        # next on the tree?
                        if (ithis == thread) {
                                ancestry(ithis) = YES
                                thread = iprev
                                if (thread == 0)
                                        break   # scan thru header is complete
                        }
        }
}

call note(seekptr, fdhis)      # tag the start of the text portion of the file
return
end

#-t- setget          3385  asc  20-jan-82 14:32:41  npg
#-h- rstget           979  asc  20-jan-82 14:32:42  npg
#-p-
#******************************************************************************
#*
#*
#*                               RSTGET
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Restore read pointer to start of text info in the Text
#*       Control System file.
#*
#*
#*    Calling convention:   rstget(junk)
#*
#*
#*    Formal Parameters
#*
#*
#*
#*    Global Variables Changed
#*       insert:  Mode of scanner in LINEGET. Reset here, but forced to
#*          correct value in LINEGET anyway when it reads the "version 1"
#*          keyline because "version 1.1" is everybodies ancestor.
#*
#*
#*    Modules called by RSTGET
#*       seek
#*
#*
#*    Modules which call RSTGET
#*       (unknown)
#*
#*
#******************************************************************************
#-p-
subroutine rstget(junk)

include "decls"

call seek(seekptr, fdhis)       # point to start of data portion
insert = OFF                    # current mode

return
end
#-t- rstget           979  asc  20-jan-82 14:32:42  npg
#-h- lineget         2659  asc  20-jan-82 14:32:44  npg
#-p-
#******************************************************************************
#*
#*
#*                               LINEGET
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Ancestry has been established. Develop the particular version
#*    Returns a line-at-a-time to caller.
#*
#*
#*    Calling convention:   lineget (inbuf, passthru)
#*
#*
#*    Formal Parameters
#*       inbuf:  buffer to fill with next line from appropriate ancestor
#*          version.
#*       passthru:  flag signalling that ".tcs" file is being regenerated.
#*          Used only in the version of this file compiled into DELTA.
#*
#*
#*    Module Returns:  the number of chars in the line read from the file or
#*       EOF at end-of-file.
#*
#*
#*    Modules called by LINEGET
#*       error
#*       puttag
#*       putlin
#*       getlin
#*       bmatch
#*       ctoi2
#*
#*
#*    Modules which call LINEGET
#*       main
#*
#*
#*    Description of algorithm:
#*       Based on the "family tree" set up in the ancestry array, the
#*       appropriate text line are passed back to the caller.
#*       The local variable (saved upon return) CURRNEST keeps track of the
#*       current level of being retrieved.
#*
#*
#******************************************************************************
#-p-

integer function lineget (inbuf, passthru)
character inbuf(MAXLINE)
integer passthru                        # send text to new-history file

include "decls"

integer bmatch, ctoi2, getlin

integer currnest, i
string sinsert INSERT
string sdelete DELETE
string sendseg ENDSEG
save currnest

repeat {
        i = getlin(inbuf, fdhis)
        if (i == EOF)
                call error("Unexpected EOF on history-data scan.")

        if (bmatch(inbuf, 1, sendseg) != 0) {
                if (ctoi2(inbuf, KEYSIZ) == 1) {                # done
GET                     if (passthru == YES)
GET                             call putlin(inbuf, fdscr)       # last line
                        break
                }
                if (insert == OFF)
                        if (ctoi2(inbuf, KEYSIZ) == currnest)
                                insert = ON
        } else if (bmatch(inbuf, 1, sinsert) != 0)
                if (ancestry(ctoi2(inbuf, KEYSIZ)) == YES)
                        insert = ON
                else {
                        # not in one of its ancestors,
                        # skip to matching ENDSEG line
                        if (insert == ON) {
                                currnest = ctoi2(inbuf, KEYSIZ)
                                insert = OFF
                        }
                }
        else if (bmatch(inbuf, 1, sdelete) != 0) {
                if (ancestry(ctoi2(inbuf, KEYSIZ)) == YES)
                        # skip to matching ENDSEG line
                        if (insert == ON) {
                                currnest = ctoi2(inbuf, KEYSIZ)
                                insert = OFF
                        }
        } else
                if (insert == ON)
                        return (i)      # text returned in "inbuf"

GET     # pass all other lines thru to the output file
GET     if (passthru == YES) {
GET             if (flag == INHIST) {
GET                     call puttag(sendseg)
GET                     flag = MATCHING
GET             }
GET             call putlin(inbuf, fdscr)
GET     }
}

return (EOF)    # at EOF
end

#-t- lineget         2659  asc  20-jan-82 14:32:44  npg
#-h- aputlin         1120  asc  20-jan-82 14:32:45  npg
#-p-
#******************************************************************************
#*
#*
#*                               APUTLIN
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  call putlin, but start at a (given) offset in the line
#*
#*
#*    Calling convention:   aputlin(str, off, outfd)
#*
#*
#*    Formal Parameters
#*       str:  source text string
#*       off:  offset in string at which to begin output
#*       outfd:  output file-descriptor
#*
#*
#*    Modules called by APUTLIN
#*       putlin
#*
#*
#*    Modules which call APUTLIN
#*       main
#*       setget
#*
#*
#******************************************************************************
#-p-

subroutine aputlin(str, off, outfd)
character str(MAXLINE)
integer off, outfd

character tmplin(MAXLINE)
integer i, j

i = off-1
j = 1                           # start of buffer
repeat {
        i = i+1                 # point TO the char xferred
        tmplin(j) = str(i)
        j = j+1                 # point AFTER the char just xferred
} until ((str(i) == EOS) | (str(i) == NEWLINE))
tmplin(j) = EOS                 # terminate the string
call putlin(tmplin, outfd)

return
end
#-t- aputlin         1120  asc  20-jan-82 14:32:45  npg
#-t-  get.r                     21276  ascii   04/02/82  16:06:08
#-h-  get.rof                    3065  ascii   04/02/82  17:15:56
.bp 
.rm 70 
.in 0 
.he 'GET (1)'9/14/81'GET (1)'
.fo ''-#-' 
.fi 
.in 7 
.ti -7 
NAME 
.br 
get - get generation from TCS file
.sp 1 
.ti -7 
SYNOPSIS 
.br 
get [-h][-rM.N] historyfile [resultfile]
.sp 1 
.ti -7 
DESCRIPTION 
.br 
Get retrieves earlier versions of text from "historyfile" 
as computed by DELTA.

The possible flags are:
.br

.in +10
(none) - The latest version of the file is retrieved.

-h - Print out the history information associated with the
versions.
The dates, times, and user IDs will be retrieved, along with
the comments added while performing the DELTAs.

-rM.N - Retrieve the specified version M.N into the "result" file.
.in -10

The retrieved version will be put in the "result" file
if specified, otherwise it is sent to the standard output.
History information is always sent to the terminal.
.sp 1 
.ti -7 
FILES 
.br 
None
.sp 1
.ti -7 
SEE ALSO 
.br 
ADMIN, DELTA.
.br
"The Source Code Control System", by Marc J. Rochkind,
.ul
IEEE Transactions on Software Engineering,
Vol. Se-1, No. 4, December 1975.
.sp
.ti -7
EXAMPLES
.br
get program.tcs program
.in +5
Retrieve the latest version of the program stored on "program.tcs",
placing it on the file "program".
.in -5
.sp
get -h program.tcs
.in +5
Print out the history of changes made to the program stored on "program.tcs".
.in -5
.sp
get -r1.13.2 tcsfile
.in +5
Print (on standard output) the version number 1.13.2 of the text stored
in "tcsfile".
.in -5
.sp
Text is stored in TCS format by calling "admin", and versions are
created by using the tool "delta".
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
.in +10 
.ti -10
Usage: get [-h][-rM.N] historyfile [resultfile]
.br 
Correct calling format is provided when called without arguments.

.ti -10
Unexpected EOF on history-info scan.
.ti -10
.br
The source file does not contain the code which identifies it
as a TCS history file.
The code may be entered via the ADMIN command.

.ti -10
Unexpected EOF on history-data scan.
.br
The file format has been tampered with and is no longer
recognizable.
Refer to a guru for repair.
  
.ti -10
- missing from keyletter
.br 
First argument is expected to qualify whether versions and/or
histories are to be extracted.
.br 
  
.ti -10
Illegal keyletter
.br 
Only 'h' and 'r' are valid keys.
.br 
  
.ti -10
Nonexistant revision level requested.
.br 
The version number specified is not contained in the history.
Try "get -h file.tcs" to view the versions available.
.br 
  
.ti -10
Invalid history file
.br 
The history file specifies impossible line-number correlations.
Either out-of-sequence changes or line numbers in descending order.
.br 

.ti -10
Cannot locate TCS history file.
.br
Could not find file supplied for historyfile.
.br

.in -10
.ti -7 
AUTHORS 
.br 
An Algorithm for Differential File Comparison by J.W.Hunt
and M.D.McIlroy (BTL Computing Science Technical Report #41).
Original code by Wil Baden;
converted from MORTRAN by Dave Murray.
Modifications and conversion to BTL-SCCS style by Neil
Groundwater at Analytic Disciplines Inc.
.sp 1 
.ti -7 
BUGS/DEFICIENCIES 
.br 
#-t-  get.rof                    3065  ascii   04/02/82  17:15:56
