#
#       @(#)Makefile	derived from 1.4 89/01/13 NFS Rev 2 Testsuite
#
# to make tests, use 'make'
# to copy tests to another directory, use 'make copy DESTDIR=dir'
# to copy source to another directory, use 'make dist DESTDIR=dir'

CC = cl
TESTS = dupreq$(EXE) excltest$(EXE) fstat$(EXE) \
	holey$(EXE) negseek$(EXE) nstat$(EXE) \
	op-chmod$(EXE) op-unlk$(EXE) rename$(EXE) \
	stat$(EXE) stat2$(EXE) touchn$(EXE)


DESTDIR = /no/such/path
#  Define NFS3_2 for NFS 3.2 compatibility - Comment out if not NFS 3.2
#COMPAT = -DNFS3_2
DEBUG = /Zi /Od
CFLAGS = -I..\basic $(COMPAT) $(DEBUG) -DDOS -DANSI -F 4000 /Fm /W3 /Ze
LINKFLAGS = /link /NOE
OBJ = .obj	# .o for Unix
EXE = .exe	# null for Unix
COMMONOBJ = d:\msc\5.1\lib\binmode.obj

all: origtests
	
origtests: $(TESTS)

dupreq.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

excltest.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

holey.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

negseek.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

# break following into two lines so command line not too long
nstat.exe: $*.c $(COMMONOBJ) ..\basic\subr.obj
	$(CC) $(CFLAGS) -c $*.c
	$(CC) $*$(OBJ) ..\basic\subr.obj $(COMMONOBJ) $(LINKFLAGS)

op-chmod.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

op-unlk.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

rename.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

stat.exe: $*.c $(COMMONOBJ) ..\basic\subr.obj
	$(CC) $(CFLAGS) -c $*.c
	$(CC) $*$(OBJ) ..\basic\subr.obj $(COMMONOBJ) $(LINKFLAGS)

fstat.exe: $*.c $(COMMONOBJ) ..\basic\subr.obj
	$(CC) $(CFLAGS) -c $*.c
	$(CC) $*$(OBJ) ..\basic\subr.obj $(COMMONOBJ) $(LINKFLAGS)

stat2.exe: $*.c $(COMMONOBJ) ..\basic\subr.obj
	$(CC) $(CFLAGS) -c $*.c
	$(CC) $*$(OBJ) ..\basic\subr.obj $(COMMONOBJ) $(LINKFLAGS)

touchn.exe: $*.c $(COMMONOBJ)
	$(CC) $(CFLAGS) -o $*$(EXE) $*.c $(COMMONOBJ) $(LINKFLAGS)

clean:
	-rm *$(OBJ) $(TESTS)

copy: $(TESTS)
	cp runtests $(TESTS) $(DESTDIR)

dist:
	cp runtests Makefile *.c *.h $(DESTDIR)
