/*	@(#)tests.h	1.2 89/01/08 NFS Rev 2 Testsuite	*/

/* Do all includes here so you don't have to mess with each file */

#ifndef DOS
#include <sys/param.h>
#endif
#ifndef major
#include <sys/types.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#ifdef DOS
#include <fcntl.h>
#include <dos.h>
#include <time.h>
#include "unixdos.h"
#include <direct.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#endif

#define	TESTDIR	"o:\\nfstestd"
#define	DNAME	"dir."
#define	FNAME	"file."
#define	DCOUNT	10
#define	DDIRS	2
#define	DLEVS	5
#define	DFILS	5

#ifdef DOS
#define CHMOD_MASK (S_IREAD | S_IWRITE)
#define CHMOD_YES CHMOD_MASK
#define CHMOD_NO S_IREAD
#else
#define CHMOD_MASK 0777
#define CHMOD_YES 0666
#define CHMOD_NO 0
#endif

#ifdef ANSI
void error(char *str,...);
void starttime(void);
void endtime(struct timeval *tv);
void printtimes(struct timeval *tv, long nbytes);
void testdir(char *dir);
int mtestdir(char *dir);
long getparm(char *parm, long min, char *label);
void complete(void);
int unix_chdir(char *path);
void dirtree(int lev, int files, int dirs, char *fname, char *dname, int *totfiles, int *totdirs);
void rmdirtree(int lev, int files, int dirs, char *fname, char *dname, int *totfiles, int *totdirs, int ignore);
#ifdef DOS
char *getwd(char *path);
#endif
int unix_chmod(char *path, int mode);
#endif

extern int errno;

extern char *Myname;		/* name I was invoked with (for error msgs) */

