/*
 * Location of the users' stored registers.
 * Usage is u.u_ar0[XX].
 */
#define R0      0               /* general registers */
#define R1      1
#define R2      2
#define R3      3
#define R4      4
#define R5      5
#define R6      6
#define R7      7
#define R8      8
#define R9      9
#define R10     10
#define R11     11
#define R12     12
#define R13     13
#define R14     14
#define R15     15

#define RPS     16              /* first half of PSW */
#define RPC     17              /* second half of PSW */

#define FR0     18              /* floating point registers */
#define FR2     20              /* (two words each) */
#define FR4     22
#define FR6     24

#define SZREGS  (26*4)          /* size of all these regs on the stack */
