/*
 * UNIX Version of VIO
 */
#include "../h/conf.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/ioconf.h"

#define K       1024
#define M       1024*K
#define VIOSIZ  2*M
#define MAXPAG  (VIOSIZ/PSIZE)
#define BLKPAG  (PSIZE/BSIZE)
#define MAXBLK  (MAXPAG*BLKPAG)

char *vioptb0[MAXPAG];

char **viodev[NVIO] = {
        vioptb0
};
char **vioptb;

viostrat(bp)
struct buf *bp;
{
        int pageno,offset;
        char *pagaddr;

        if (bp->b_blkno < 0
            || bp->b_blkno>=MAXBLK
            || minor(bp->b_dev)>=NVIO){
                bp->b_flags |= B_ERROR;
                iodone(bp);
                return;
        }
        vioptb = viodev[minor(bp->b_dev)];
        pageno = bp->b_blkno/BLKPAG;
        pagaddr = vioptb[pageno];
        offset = (bp->b_blkno%BLKPAG)*BSIZE;
        if (bp->b_flags & B_READ){
                if (!pagaddr)
                        clrbuf(bp);
                else
                        bcopy(pagaddr+offset,bp->b_un.b_addr,BSIZE);
        } else {
                if (!pagaddr)
                        vioptb[pageno] = pagaddr = getpage();
                bcopy(bp->b_un.b_addr,pagaddr+offset,BSIZE);
        }
        iodone(bp);
}
