/*
 * Priority queueing routines for I/O.
 * Priority is based on age of queue element,
 * to guarantee FIFO scheduling of requests for
 * any one device.
 */
 
#include "../h/io.h"
#include "../h/ios.h"
#define NIOQ    100
#define NULL    0
 
struct ioq ioqs[NIOQ];
struct ioq *ffioq;
int     nioq;
int     nioqf;
 
/*
 * Get a queue element.
 */
struct ioq *
getq()
{
        struct ioq *q;
 
        if((q = ffioq) == NULL) {
                ipanic("no ioq\n");
        }
        ffioq = ffioq->io_next;
        q->io_next = NULL;
        q->io_qnum = ++nioq;
        return(q);
}
 
/*
 * Free a queue element.
 */
freeq(q)
struct ioq *q;
{
        if(q->io_qnum == 0) {
		ipanic("freeq - q freed twice");
        }
        q->io_qnum = 0;
        q->io_mint = 0;
        ++nioqf;
        q->io_next = ffioq;
        ffioq = q;
}
 
/*
 * Initialize the free list.
 */
ioqinit()
{
        struct ioq *q;
 
        for(q = ioqs; q < &ioqs[NIOQ]; q++)
                q->io_next = q + 1;
        (q-1)->io_next = NULL;
        ffioq = ioqs;
}
 
/*
 * Enqueue element 'l' on queue 'q'.
 */
ioenq(l, qp)
struct ioq *l, **qp;
{
	register struct ioq *q;

	q = (struct ioq *)qp;   /* because io_next is first in ioq */
        if(l->io_qnum == 0) {
		ipanic("ioenq - zero qnum");
        }
        while(q->io_next != NULL && q->io_next->io_qnum < l->io_qnum)
                q = q->io_next;
        l->io_next = q->io_next;
        q->io_next = l;
}
 
/*
 * Return first element in queue 'q'.
 */
struct ioq *
iodeq(q)
struct ioq **q;
{
        struct ioq *p;
 
        p = *q;
        if(p != NULL) *q = p->io_next;
        return(p);
}

/*
 * Determine if there are any missing interrupts.
 */

iotic()
{
	static mint = MINT;
	register struct ioq *q;
	struct chan *ch;
	struct cu *cu;
	struct unit *un;

	if (--mint)
		return;
	mint = MINT;
	for (q = &ioqs[0]; q < &ioqs[NIOQ]; q++)
		if (q->io_mint > 0 && (q->io_mint -= MINT) <= 0) {
			/*
			 * We have a missing interrupt.
			 */
			q->io_mint = -1;
			if (iolkup(q->io_devaddr, &ch, &cu, &un))
				panic("iotic - no device");
			ch->ch_state = FREE;
			cu->cu_state = FREE;
			un->un_state = FREE;
			un->un_actv = 0;
			q->io_type = CLR_HDV;
			iostart(q);
		}
}
