/*
 * Routines for simulating 3270 input
 */

#include <tcl/3270.h>
#include <tcl/tclio.h>
#include <tcl/screen.h>
#include <tcl/keyboard.h>
#include <stdio.h>

doinput(aid)
{
	register char *p;
	register int i, j;

	noinhibit();
	p = inbuf.data;
	*p++ = aid;
	if(aid == CLEAR) {
		clear(scr_data, SCRSIZE);
		clear(scr_attr, SCRSIZE);
		bufaddr = 0;
		cursaddr = 0;
	}
	if(aid != CLEAR && aid != PA1 && aid != PA2 && aid != TESTREQ) {
		*p++ = tubecc[cursaddr >> 6];
		*p++ = tubecc[cursaddr & 077];
	}
	if(aid == TESTREQ) {
		p[-1] = SOH;
		*p++ = tubotab['%'];
		*p++ = tubotab['/'];
		*p++ = STX;
	}
	if(aid != CLEAR && aid != PA1 && aid != PA2) {
                for(i=0; i<SCRSIZE; i++) {
                        if((scr_attr[i] & (STARTFLD|MDT)) == (STARTFLD|MDT)) {
                                j = i;
                                incmod(j, SCRSIZE);
                                sba(p, j);
                                for(; (scr_attr[j] & STARTFLD) == 0 && j != i; incmod(j, SCRSIZE))
                                        if(scr_data[j])
                                                *p++ = tubotab[scr_data[j]];
                        }
                }
	}
	inbuf.len = p - inbuf.data;
	if(putinput())
		fprintf(stderr, "doinput: putinput failed\n");
	do {
                getoutput();
	} while(poll(ldfd));
}

inputtxt(s)
char *s;
{
	int i;

	noinhibit();
        if(scr_attr[cursaddr] & (STARTFLD|PROT))
                return(2);
	i=cursaddr;
	decmod(i, SCRSIZE);
	while((scr_attr[i] & STARTFLD) == 0 && i != cursaddr)
		decmod(i, SCRSIZE);
	if(scr_attr[i] & STARTFLD)
		scr_attr[i] |= MDT;
	while(*s) {
		if(*s == '\n') {
			domove(M_NL);
			s++;
			continue;
		}
		if(scr_attr[cursaddr] & (STARTFLD|PROT))
			return(1);
		scr_data[cursaddr] = *s++;
		incmod(cursaddr, SCRSIZE);
	}
	return(0);
}

noinhibit()
{
	while(kbd == LOCKED || poll(ldfd)) {
		getoutput();
		if(unsolicited)
			fprintf(stderr, "noinhibit: unsolicited read\n");
	}
}

domove(motion)
{
	int i, j;

	switch(motion) {

	case M_UP:
		cursaddr -= 80;
		if(cursaddr < 0) cursaddr += SCRSIZE;
		break;

	case M_DOWN:
		cursaddr += 80;
		if(cursaddr >= SCRSIZE) cursaddr -= SCRSIZE;
		break;

	case M_LEFT:
		decmod(cursaddr, SCRSIZE);
		break;

	case M_RIGHT:
		incmod(cursaddr, SCRSIZE);
		break;

	case M_FORW:
		i = cursaddr;
		j = SCRSIZE;
		while(j--) {
			incmod(i, SCRSIZE);
			if((scr_attr[i] & (STARTFLD|PROT)) == STARTFLD)
				break;
		}
		if(j < 0)
			cursaddr = 0;
		else
			cursaddr = incmod(i, SCRSIZE);
		break;

	case M_BACK:
		i = decmod(cursaddr, SCRSIZE);
		j = SCRSIZE;
		while(j--) {
			decmod(i, SCRSIZE);
			if((scr_attr[i] & (STARTFLD|PROT)) == STARTFLD)
				break;
		}
		if(j < 0)
			cursaddr = 0;
		else
			cursaddr = incmod(i, SCRSIZE);
		break;

	case M_NL:
		i = cursaddr - (cursaddr%80) + 80;
		if(i >= SCRSIZE) i -= SCRSIZE;
		j = SCRSIZE;
		while(j--) {
			if((scr_attr[i] & (PROT|STARTFLD)) == 0)
				break;
			incmod(i, SCRSIZE);
		}
		if(j < 0)
			cursaddr = 0;
		else
			cursaddr = i;
		break;
	}
}

doedit(edit)
{
	int i, j;

	switch(edit) {

	case E_EINPUT:  /* erase input */
		cursaddr = -1;
		for(i=0; i<SCRSIZE; i++) {
			if((scr_attr[i] & PROT) == 0) {
				scr_data[i] = 0;
				if(scr_attr[i] & STARTFLD)
                                        scr_attr[i] &= ~MDT;
				else
                                        if(cursaddr == -1) cursaddr = i;
			}
		}
		if(cursaddr == -1) cursaddr = 0;
		break;

	case E_EEOF:    /* erase to end-of-field */
		i = cursaddr;
		if(scr_attr[i] & (PROT|STARTFLD))
			return;
		do {
			incmod(i, SCRSIZE);
	        } while((scr_attr[i] & STARTFLD) == 0 && i != cursaddr);
		if(i == cursaddr) i = 0;
		for(j = cursaddr; j != i; incmod(j, SCRSIZE)) {
			scr_data[j] = 0;
		};
		break;
	}
}
