/*
 * Called by the puthw, putw, and putdw macros in stdio.h
 * when p->_cnt has gone negative.
 */

#include <stdio.h>
#include <stdioerr.h>

long
_putw(x, p, size)
	long    x;
	FILE    *p;
	int     size;
{
	register char    *p1, *p2;

	if (p == NULL)
		return(_stdioerr(EFPNULL, "putw"));
	p->_cnt += size;
        p2 = (char *) &x + sizeof(x);
	p1 = p2 - size;
        while (p1 < p2)
		putc(*p1++, p);
	return(x);
}
