/*
 * C object code improver-- second part
 */

#include "c2.h"

#define NREG 16+(2*4)
#define FLT  16

#define NALIAS 20
struct alias {
	int a_regs;     /* bit map of registers containing a_name */
	int a_base;     /* bit map of possible base regs for a_name */
	int a_type;     /* type of operand usage (half, flt, etc) */
	char a_name[40];      /* the operand itself */
} aliases[NALIAS];
#define ALLALIAS ap=aliases; ap<&aliases[NALIAS]; ap++


/* instruction types for parsing */
#define RR 1
#define RX 2
#define RS 3

/* instruction operands */
int rop1, rop2, rop3;
char op1[40], op2[40];
int op2base;
int curbase;            /* map of current base registers */

/*
 * Find and remove redundant moves (loads, stores)
 */
rmove()
{
	register struct node *p;
	int ntried, nmissed;

	clearreg();
	ntried = nmissed = 0;
	for (p=first.forw; p!=0; p = p->forw) {
	ntried++;
	switch (p->op) {

	case FLOAD:
		do_load(p, FLT);
		break;

	case LOAD:
		do_load(p, 0);
		break;

	case LM:
		do_lm(p);
		break;

	case FSTORE:
		do_store(p, FLT);
		break;

	case STORE:
		do_store(p, 0);
		break;

	case STM:
		do_stm(p);
		break;

	case FADD:
	case FCMP:
	case FDIV:
	case FMULT:
	case FSUB:
		if(do_gen(p, FLT))
			p = p->forw;
		break;

	case ADD:
	case ADDL:
	case AND:
	case XOR:
	case OR:
	case SUB:
	case SUBL:
	case MULT:
	case DIV:
	case CMP:
	case CMPL:
		if(do_gen(p, 0))
			p = p->forw;
		break;

	case LTR:
		do_ltr(p);
		break;

	case FLTR:
		do_fltr(p);
		break;

	case LA:
	case IC:
	case SLA:
	case SLL:
	case SRA:
	case SRL:
		parse(p, RX);
		delreg(rop1);
		break;

	case SLDA:
	case SLDL:
	case SRDA:
	case SRDL:
		parse(p, RX);
		delreg(rop1);
		delreg(rop1+1);
		break;

	case CBR:
	case BCR:
		if(p->subop == BNE)
			do_bne(p);
		break;

	case JBR:
	case JSW:
	case ENTRY:
	case LTORG:
	case COMM:
	case DC:
	case DS:
	case EQU:
		break;

	case LABEL:
	case DLABEL:
	case TEXT:
	case DATA:
	case BSS:
	case BALR:
		clearreg();
		break;

	case EROU:
		do_drop(p);
		clearreg();
		break;

	case USING:
		do_using(p);
		break;

	default:
		clearreg();
		nmissed++;
		break;
	}
	}
	if(debug) {
		check();
	        fprintf(stderr, "rmove: %d of %d missed\n", nmissed, ntried);
	}
}

/*
 * Process loads: L, LH, LD, LE, LR, LDR, LER
 */
do_load(p, flt)
register struct node *p;
{
	int r, litval;

        if(!(p->subop & REG)) {   /* L, LH, LD, LE */
                parse(p, RX);
                if(rmatch(rop1+flt, op2, p->subop)) {
                        /* already in right register */
                        unchain(p);
                        redunm++;
                        nchange++;
                } else if((r = match(op2, p->subop)) != -1) {
                        /* already in another register */
                        delreg(rop1+flt);
			if(p->subop == HALF) p->subop = 0;
                        p->subop |= REG;
                        p->code = alloc(sizeof "xx,yy");
                        sprintf(p->code, "%d,%d", rop1, r-flt);
                        dupreg(r, rop1+flt);
                        nrxrr++;
                        nchange++;
                } else {
                        delreg(rop1+flt);
                        if(flt || (op2base & (1 << rop1)) == 0)
                                /* doesn't alter own base reg */
                                regname(rop1+flt, op2, op2base, p->subop);
                        if(!flt && sscanf(op2, "=f'%d'", &litval) > 0) {
                                if(litval == 0) {
                                        p->op = SUB;
                                        p->subop |= REG;
                                        p->code = alloc(sizeof "xx,yy");
                                        sprintf(p->code, "%d,%d", rop1, rop1);
                                        nlit++;
                                        nchange++;
                                } else if(litval > 0 && litval < 4096) {
                                        p->op = LA;
                                        p->code = alloc(sizeof "xx,nnnn");
                                        sprintf(p->code, "%d,%d", rop1, litval);
                                        nlit++;
                                        nchange++;
                                }
                        }
                }
        } else {      /* LR, LDR, LER */
                parse(p, RR);
                if(rop1 == rop2 || ralias(rop1+flt, rop2+flt)) {
                        /* unneeded LR */
                        unchain(p);
                        redunm++;
                        nchange++;
                } else {
                        delreg(rop1+flt);
                        dupreg(rop2+flt, rop1+flt);
                }
        }
}

/*
 * Remove redundant stores: ST, STH, STC, STD, STE
 */
do_store(p, flt)
register struct node *p;
{
        parse(p, RX);
        if(rmatch(rop1+flt, op2, p->subop)) {
                /* unneeded ST, STH, STC, STD, or STE */
                unchain(p);
                redunm++;
                nchange++;
        } else {
                delname(op2);
                regname(rop1+flt, op2, op2base, p->subop);
        }
}

/*
 * Process Load Multiples
 * Either delete it entirely, whittle it down, or keep as is.
 */
do_lm(p)
struct node *p;
{
	register int nr1, nr3, nreg;
	int off, ioff, eoff, r, delbase;
	char rest[40];

	parse(p, RS);
	nreg = rop3-rop1+1;
	if(nreg <= 0) nreg += 16;
	if(sscanf(op2, "%d%s", &off, rest) == 2 && rest[0] != 'b' && rest[0] != 'f') {
		ioff = off;
		eoff = off + 4*(nreg-1);
		nr1 = rop1;
		while(nreg > 0 && rmatch(nr1, op2, 0)) {
			nreg--;
			nr1 = (nr1+1) & 0xF;
			ioff += 4;
			sprintf(op2, "%d%s", ioff, rest);
		}
		nr3 = rop3;
		sprintf(op2, "%d%s", eoff, rest);
		while(nreg > 0 && rmatch(nr3, op2, 0)) {
			nreg--;
			nr3 = (nr3-1) & 0xF;
			eoff -= 4;
			sprintf(op2, "%d%s", eoff, rest);
		}
		if(nreg == 0) {
			unchain(p);
			redunm++;
			nchange++;
		} else {
			if(nr1 != rop1 || nr3 != rop3) {
				p->code = alloc(40);
				if(nr1 == nr3) {
					p->op = LOAD;
					sprintf(p->code, "%d,%d%s", nr1, ioff, rest);
				} else {
                                        sprintf(p->code, "%d,%d,%d%s", nr1, nr3, ioff, rest);
				}
				redunm++;
				nchange++;
			}
			delbase = 0;
			rop1 = nr1;
			do {
				delreg(nr1);
				r = nr1;
				if(op2base & (1<<nr1))
					delbase = 1;
				nr1 = (nr1+1) & 0xF;
			} while(r != rop3);
			if(!delbase) {
                                nr1 = rop1;
				do {
					sprintf(op2, "%d%s", ioff, rest);
					regname(nr1, op2, op2base, 0);
					r = nr1;
					nr1 = (nr1+1) & 0xF;
					ioff += 4;
				} while(r != rop3);
			}
		}
	} else {
		do {
			delreg(rop1);
			r = rop1;
			rop1 = (rop1+1) & 0xF;
		} while(r != rop3);
	}
}

/*
 * Process Store Multiples
 * Same as above + delname - delreg
 */
do_stm(p)
struct node *p;
{
	register int nr1, nr3, nreg;
	int off, ioff, eoff, r;
	char rest[40];

	parse(p, RS);
	nreg = rop3-rop1+1;
	if(nreg <= 0) nreg += 16;
	if(sscanf(op2, "%d%s", &off, rest) == 2 && rest[0] != 'b' && rest[0] != 'f') {
		ioff = off;
		eoff = off + 4*(nreg-1);
		nr1 = rop1;
		while(nreg > 0 && rmatch(nr1, op2, 0)) {
			nreg--;
			nr1 = (nr1+1) & 0xF;
			ioff += 4;
			sprintf(op2, "%d%s", ioff, rest);
		}
		nr3 = rop3;
		sprintf(op2, "%d%s", eoff, rest);
		while(nreg > 0 && rmatch(nr3, op2, 0)) {
			nreg--;
			nr3 = (nr3-1) & 0xF;
			eoff -= 4;
			sprintf(op2, "%d%s", eoff, rest);
		}
		if(nreg == 0) {
			unchain(p);
			redunm++;
			nchange++;
		} else {
			if(nr1 != rop1 || nr3 != rop3) {
				p->code = alloc(40);
				if(nr1 == nr3) {
					p->op = STORE;
					sprintf(p->code, "%d,%d%s", nr1, ioff, rest);
				} else {
                                        sprintf(p->code, "%d,%d,%d%s", nr1, nr3, ioff, rest);
				}
				redunm++;
				nchange++;
			}
                        do {
                                sprintf(op2, "%d%s", ioff, rest);
				delname(op2);
                                regname(nr1, op2, op2base, 0);
                                r = nr1;
                                nr1 = (nr1+1) & 0xF;
                                ioff += 4;
                        } while(r != rop3);
		}
	} else {
		clearreg();
	}
}

/*
 * Process general RX or RR instructions
 */
do_gen(p, flt)
register struct node *p;
{
	int skipnext = 0;
	register int r;
	register struct node *fp;

        if(!(p->subop & REG)) {  /* try to collapse RX to RR */
                parse(p, RX);
                if((r = match(op2, p->subop)) != -1) {
			if(p->subop == HALF) p->subop = 0;
                        p->subop |= REG;
                        p->code = alloc(sizeof "xx,yy");
                        sprintf(p->code, "%d,%d", rop1, r-flt);
                        nrxrr++;
                        nchange++;
                }
        } else {
                parse(p, RR);
                if(rop1 == rop2 && (p->op==SUB||p->op==SUBL||p->op==XOR)) {
                        if(rmatch(rop1, "=0", 0)) {
                                unchain(p);
                                redunm++;
                                nchange++;
                                rop1 = -1;
                        }
                        if(p->forw->op == IC) {
                                fp = p->forw;
                                r = rop1;
                                parse(fp, RX);
                                if(r == rop1) {
                                        if(rmatch(rop1, op2, CHAR)) {
                                                unchain(p);
                                                unchain(fp);
                                                redunm++;
                                                nchange++;
                                                skipnext = 1;
                                        } else if((r=match(op2, CHAR)) != -1) {
                                                p->op = LOAD;
                                                p->subop = REG;
                                                p->code = alloc(sizeof "xx,yy");
                                                sprintf(p->code, "%d,%d", rop1, r);
                                                nrxrr++;
                                                nchange++;
                                                unchain(fp);
                                                dupreg(r, rop1);
                                        } else {
                                                delreg(rop1);
                                                regname(rop1, op2, op2base, CHAR);
                                                skipnext = 1;
                                        }
                                } else {
                                        delreg(r);
                                }
                                rop1 = -1;
                        } else {
                                delreg(rop1);
                                regname(rop1, "=0", 0, 0);
                                rop1 = -1;
                        }
                } else if(rop1 == rop2 && p->op == FSUB) {
                        if(rmatch(rop1+flt, "=0", p->subop&~REG)) {
                                unchain(p);
                                redunm++;
                                nchange++;
                                rop1 = -1;
                        } else {
                                delreg(rop1+flt);
                                regname(rop1+flt, "=0", 0, p->subop&~REG);
                                rop1 = -1;
                        }
                }
        }
        if(rop1 != -1 && p->op != CMP && p->op != CMPL && p->op != FCMP) {
                delreg(rop1+flt);
                if(p->op == DIV || (p->op == MULT && p->subop != HALF))
                        delreg(rop1+1);
        }
	return(skipnext);
}

/*
 * Remove redundant LTRs, map 'LR,LTR' to just LTR
 */
do_ltr(p)
register struct node *p;
{
	register struct node *bp, *fp;
	register int r;

        parse(p, RR);
        if(rop1 == rop2) {
                bp = p->back;
                fp = p->forw;
                r = rop1;
                switch(bp->op) {
                case LOAD:
                        if(bp->subop & REG) {
                                parse(bp, RR);
                                if(r == rop1 || r == rop2) {
                                        bp->op = LTR;
                                        bp->subop = 0;
                                        unchain(p);
                                        nltr++;
                                        nchange++;
                                }
                        }
                        break;
                case ADD:
                case SUB:
                        if(bp->subop & REG)
                                parse(bp, RR);
                        else
                                parse(bp, RX);
                        if(r == rop1) {
                                unchain(p);
                                nltr++;
                                nchange++;
                        }
                        break;
                case AND:
                case XOR:
                case OR:
                        if(fp->op == CBR && (fp->subop == BNE || fp->subop == BE)) {
                                if(bp->subop & REG)
                                        parse(bp, RR);
                                else
                                        parse(bp, RX);
                                if(r == rop1) {
                                        unchain(p);
                                        nltr++;
                                        nchange++;
                                }
                        }
                        break;
                }
        } else {
                delreg(rop1);
                dupreg(rop2, rop1);
        }
}

/*
 * Remove redundant LTERs, LTDRs
 */
do_fltr(p)
register struct node *p;
{
	register struct node *bp;
	register int r;

        parse(p, RR);
        if(rop1 == rop2) {
                bp = p->back;
                r = rop1;
                switch(bp->op) {
                case FLOAD:
                        if(bp->subop == p->subop) {
                                parse(bp, RR);
                                if(r == rop1 || r == rop2) {
                                        bp->op = p->op;
                                        bp->subop = p->subop;
                                        unchain(p);
                                        nltr++;
                                        nchange++;
                                }
                        }
                        break;
                case FADD:
                case FSUB:
                        if(bp->subop == p->subop) {
                                parse(bp, RX);
                                if(r == rop1) {
                                        unchain(p);
                                        nltr++;
                                        nchange++;
                                }
                        }
                        break;
                }
        } else {
                delreg(rop1+FLT);
                dupreg(rop2+FLT, rop1+FLT);
        }
}

/*
 * Process knowledge of stuff after a BNE or BNZ fails
 */
do_bne(p)
struct node *p;
{
	register struct node *bp;
	register int flt = 0;

        bp = p->back;
        switch(bp->op){
        case FCMP:
                flt = FLT;
        case CMP:
        case CMPL:
                if(bp->subop & REG) {
                        parse(bp, RR);
                        dupreg(rop1+flt, rop2+flt);
                } else {
                        parse(bp, RX);
                        regname(rop1+flt, op2, op2base, bp->subop);
                }
                break;
        case FADD:
        case FLTR:
        case FSUB:
                flt = FLT;
        case LTR:
        case ADD:
        case ADDL:
        case AND:
        case XOR:
        case OR:
        case SUB:
        case SUBL:
                parse(bp, RX); /* includes RR */
                regname(rop1+flt, "=0", 0, bp->subop&~REG);
                break;
        }
}

/*
 * Forget everything we know about the contents of registers
 */
clearreg()
{
	register struct alias *ap;

	for(ALLALIAS) {
		ap->a_regs = 0;
	}
}

/*
 * Forget everything we know about one register
 * and the variables based on it.
 */
delreg(r)
{
	register int mask;
	register struct alias *ap;

	mask = 1 << r;
	for(ALLALIAS) {
		if(ap->a_base & mask)
			ap->a_regs = 0;
		else
			ap->a_regs &= ~mask;
	}
}

/*
 * Forget everything we know about an operand
 */
delname(name)
char *name;
{
	register struct alias *ap;

	for(ALLALIAS) {
		if(strcmp(name, ap->a_name) == 0) {
			ap->a_regs = 0;
			ap->a_name[0] = 0;
		}
	}
}

/*
 * Determine if two registers are equivalent
 */
ralias(r1, r2)
{
	register int mask;
	register struct alias *ap;

	mask = (1 << r1) | (1 << r2);
	for(ALLALIAS) {
		if((ap->a_regs & mask) == mask)
			return(1);
	}
	return(0);
}

/*
 * Replicate the knowledge for one register to another register
 */
dupreg(r1, r2)
{
	register int mask1, mask2;
	register struct alias *ap;
	static int unique = 1;
	char ubuf[10];

	mask1 = 1 << r1;
	mask2 = 0;
	do {
                for(ALLALIAS) {
                        if(ap->a_regs & mask1) {
                                mask1 |= ap->a_regs;
                                mask2 |= mask1;
			}
                }
		if(mask2 == 0) {
			sprintf(ubuf, "?%d", unique++);
			regname(r1, ubuf, 0, 0);
		}
	} while(mask2 == 0);      /* repeats at most once */
	mask2 |= 1 << r2;
	for(ALLALIAS) {
		if(ap->a_regs & mask1)
			ap->a_regs |= mask2;
	}
}

/*
 * Remember a register - operand pair
 */
regname(r, name, base, type)
char *name;
{
	register struct alias *ap, *ep;

	ep = NULL;
	for(ALLALIAS) {
		if(ap->a_regs != 0) {
			if(strcmp(ap->a_name, name) == 0 && type == ap->a_type) {
				ap->a_regs |= 1 << r;
				return;
			}
		} else {
			if(ep == NULL)
				ep = ap;
		}
	}
	if(ep == NULL) {
		fprintf(stderr, "C2: Associative memory overflow\n");
		return;
	}
	ep->a_regs = 1 << r;
	strcpy(ep->a_name, name);
	ep->a_base = base;
	ep->a_type = type;
	return;
}

/*
 * See if we have an operand in any register
 */
match(name, type)
char *name;
{
	register struct alias *ap;
	register int i, j;

	for(ALLALIAS) {
		if(ap->a_regs != 0 && strcmp(ap->a_name, name) == 0
                   && ap->a_type == type) {
			for(i=0, j=ap->a_regs; i<NREG; i++, j>>=1)
				if(j & 1)
					return(i); /* register number */
		}
	}
	return(-1);
}

/*
 * See if we have an operand in a particular register
 */
rmatch(r, name, type)
char *name;
{
	register struct alias *ap;

	for(ALLALIAS) {
		if(ap->a_regs != 0 && strcmp(ap->a_name, name) == 0
                   && ap->a_type == type) {
			if(ap->a_regs & (1 << r))
				return(1);
		}
	}
	return(0);
}

/*
 * Take an instruction off the linked list
 */
unchain(p)
struct node *p;
{
	p->forw->back = p->back;
	p->back->forw = p->forw;
}

check()
{
	register struct node *p, *lp;

	lp = &first;
	for (p=first.forw; p!=0; p = p->forw) {
		if (p->back != lp) {
			fprintf(stderr, "C2: linked list messed up\n");
			abort();
		}
		lp = p;
	}
}

parse(p, type)
register struct node *p;
{
	register char *cp;
	register int n;

        cp = p->code;
	switch(type) {

	case RR:
		if(!isdigit(*cp)) fprintf(stderr, "c21 parse: RR botch\n");
		n = 0;
		while(isdigit(*cp)) {
			n = n*10 + *cp++ - '0';
		}
		rop1 = n;
		if(*cp++ != ',') fprintf(stderr, "c21 parse: RR botch\n");
		if(!isdigit(*cp)) fprintf(stderr, "c21 parse: RR botch\n");
		n = 0;
		while(isdigit(*cp)) {
			n = n*10 + *cp++ - '0';
		}
		rop2 = n;
		break;

	case RX:
		if(!isdigit(*cp)) fprintf(stderr, "c21 parse: RR botch\n");
		n = 0;
		while(isdigit(*cp)) {
			n = n*10 + *cp++ - '0';
		}
		rop1 = n;
		if(*cp++ != ',') fprintf(stderr, "c21 parse: RX botch\n");
		strcpy(op2, cp);
		op2base = curbase;
		while(*cp != '(' && *cp) cp++;
		if(*cp++ == '(') {
			if(isdigit(*cp)) {
                                n = 0;
                                while(isdigit(*cp)) {
                                        n = n*10 + *cp++ - '0';
                                }
                                op2base |= 1 << n;
			}
			if(*cp++ == ',') {
                                n = 0;
                                while(isdigit(*cp)) {
                                        n = n*10 + *cp++ - '0';
                                }
                                op2base |= 1 << n;
                        }
		}
		break;

	case RS:
		if(!isdigit(*cp)) fprintf(stderr, "c21 parse: RS botch\n");
		n = 0;
		while(isdigit(*cp)) {
			n = n*10 + *cp++ - '0';
		}
		rop1 = n;
		if(*cp++ != ',') fprintf(stderr, "c21 parse: RS botch\n");
		if(!isdigit(*cp)) fprintf(stderr, "c21 parse: RS botch\n");
		n = 0;
		while(isdigit(*cp)) {
			n = n*10 + *cp++ - '0';
		}
		rop3 = n;
		if(*cp++ != ',') fprintf(stderr, "c21 parse: RS botch\n");
		strcpy(op2, cp);
		op2base = curbase;
		while(*cp != '(' && *cp) cp++;
		if(*cp++ == '(') {
			if(isdigit(*cp)) {
                                n = 0;
                                while(isdigit(*cp)) {
                                        n = n*10 + *cp++ - '0';
                                }
                                op2base |= 1 << n;
			}
			if(*cp++ == ',') {
                                n = 0;
                                while(isdigit(*cp)) {
                                        n = n*10 + *cp++ - '0';
                                }
                                op2base |= 1 << n;
                        }
		}
		break;
	}
}

/*
 * Process USINGs - turn on bits in curbase
 */
do_using(p)
struct node *p;
{
	register char *cp;
	int n;

	/* using xxxx,n,n,n */
	for(cp = p->code; *cp != ',' && *cp; cp++) ;
	while(*cp == ',') {
		n = 0;
		while(isdigit(*++cp))
			n = 10*n + *cp - '0';
		curbase |= 1 << n;
	}
}

/*
 * Process DROPs - turn off bits in curbase
 */
do_drop(p)
struct node *p;
{
	int n;
	register char *cp;

	cp = p->code;
	if(cp == NULL || *cp == '\0') {        /* drop all */
		curbase = 0;
	} else {      /* drop certain regs */
		while(isdigit(*cp)) {
			n = 0;
			while(isdigit(*cp))
				n = 10*n + *cp++ - '0';
			curbase &= ~(1 << n);
			if(*cp++ != ',') break;
		}
	}
}
