/*
 * retreve files from the archive
 */
#include <stdio.h>
#include <errno.h>
#include <stdioerr.h>

#define ISODD(x) x & 1

#define SIZE 4096 

struct {
	char *a_name;
	char *a_call;
	char a_tape[10];
} each[20];

char cmd[256];
char line[256];
char go[256];
char wd[256];
char index[] = "/usr/spool/arch/.index";
char usage[] = "Usage: %s archname file [archname file] ...\n";
char mount[] = "/bin/tape -m -s -d 6250 %s";
char unmount[] = "/bin/tape -u %s";
char move[] = "/bin/mv %s %s%s";
char tar[] = "/bin/tar x %s %s";
char pwd[] = "/bin/pwd";
extern char *cmdname;

main(argc, argv)
int argc;
char *argv[];
{
	FILE *popen();
	FILE *fpix;
	FILE *fptest;
	char *rindex();
	char *volser;
	char *alias;
	int arrange();
	int out;
	int i;

	if (!ISODD(argc) || argc < 3) {
		fprintf(stderr, usage, cmdname);
		exit(1);
	}
	onerror(EACCES, EIGNORE);
        for (i=0; i < argc/2; i++) {
                each[i].a_name = *++argv;
                each[i].a_call   = *++argv;
        }
        fptest = popen(pwd, "r");
        fgets(wd, 256, fptest);
        pclose(fptest);
        if ((alias = rindex(wd, '\n')) != NULL)
                *alias = 0;
	strcat(wd, "/");
	if ((fpix = fopen(index, "r")) == NULL) {
		fprintf(stderr, "%s: Unable to open %sn", cmdname, index);
		exit(3);
	}
        chdir("/usr/spool");
	/*
	 * Match the files with tapes
	 */
        while (fgets(line, 256, fpix) != NULL) {
                volser = rindex(line, '\n');
                *volser = 0;
                volser = rindex(line, ' ');
                *volser++ = 0;
                out = 0;
		for (i=0; each[i].a_name; i++) {
			if (strcmp(line, each[i].a_name) == 0)
                                sprintf(each[i].a_tape, volser);
			if (each[i].a_tape[0] == 0)
                                out++;
                }
                if (out == 0)
                        break;
        }
	fclose(fpix);
        /*
         * build tar commands
         */
        for (i=0; each[i].a_name; i++) {
                switch(each[i].a_tape[0]) {
                case '*':
                        continue;
                case NULL:
                        fprintf(stderr, "%s: file %s not on archive\n", cmdname, each[i].a_name);
                        continue;
                default:
                        sprintf(go, mount, each[i].a_tape);
                        sprintf(cmd, tar, each[i].a_tape, each[i].a_name);
                        for (out=i+1; each[out].a_name; out++) {
                                if (each[out].a_tape[0] == 0)
                                        continue;
                                if (each[out].a_tape[0] == '*')
                                        continue;
                                if (strcmp(each[i].a_tape, each[out].a_tape) != 0)
                                        continue;
                                strcat(cmd, " ");
                                strcat(cmd, each[out].a_name);
                                each[out].a_tape[0] = '*';
                        }
                        system(go);
			sprintf(go, "/dev/tape/%s", each[i].a_tape);
                        while ((fpix=fopen(go, "r")) == NULL)
                                sleep(5);
                        fclose(fpix);
			system(cmd);
			sprintf(go, unmount, each[i].a_tape);
			system(go);
			break;
		}
	}
	/*
	 * Move files to their final places
	 */
	for (i=0; each[i].a_name; i++) {
		if (*each[i].a_tape == 0)
			continue;
		if (*each[i].a_call == '/')
                        sprintf(go, move, each[i].a_name, "",  each[i].a_call);
		else
                        sprintf(go, move, each[i].a_name, wd, each[i].a_call);
                system(go);
	}
	exit(0);
}
