/*
 * Use LDEVs to logon to VM id and query status of print files
 *
 * qprt [-u vmid] [-p password] [-f file]
 */

#include <signal.h>
#include <stdio.h>
#include <pwd.h>

main(argc, argv)
char **argv;
{
	int r, fr;
	struct passwd *pw, *getpwnam(), *getpwuid();
	char *getlogin(), *getpass(), idbuf[80], lbuf[130];
	char *id = NULL, *pass = NULL;
	char *l, *off, *lastline();
	int filenum = 0;

	while(--argc > 0) {
		if(**++argv == '-') {
                        switch(argv[0][1]) {
                        case 'u':
                                id = *++argv; argc--;
                                break;
                        case 'p':
                                pass = *++argv; argc--;
                                break;
                        case 'f':
                                filenum = atoi(*++argv); argc--;
                                break;
                        default:
                                usage();
                        }
		} else {
			usage();
		}
	}
	signal(SIGINTR, SIG_IGN);
	if(id == NULL) {
                id = getlogin();
                if(id != NULL)
                        pw = getpwnam(id);
                else
                        pw = getpwuid(getuid());
                if(pw != NULL)
                        id = pw->pw_vmid;
                if(pw == NULL || pw->pw_vmid == NULL || pw->pw_vmid[0] == 0) {
                        printf("VM id: ");
                        gets(idbuf);
                        id = idbuf;
                }
	}
	if(pass == NULL)
                pass = getpass("VM Password: ");
	sprintf(lbuf, "logon %s n", id);
	$open ldev;
	alarm(60);
        while(strncmp(screen(rc(24,61)), "CP READ", 7))
                $input enter;
	alarm(60);
	$input data(lbuf) enter;
	l = lastline();
	if(strncmp(l, "ENTER PASSWORD", 14) != 0) {
		fprintf(stderr, "%s\n", l);
		exit(1);
	}
	$input data(pass) enter;
	l = lastline();
	if(strncmp(l, "LOGON", 5) == 0) {
		off = "logoff";
	} else if(strncmp(l, "RECONNECTED", 11) == 0) {
		off = "disc";
	} else {
		fprintf(stderr, "%s\n", l);
		exit(1);
	}
	alarm(60);
	$input clear;
	if(filenum > 0)
		sprintf(lbuf, "query print %d", filenum);
	else
		sprintf(lbuf, "query print all");
	$input data(lbuf) enter;
	fr = 2;
	do {
		if(fr == 1) {
                        $input clear;
			sleep(1);
		}
                while(strncmp(screen(rc(24,61)), "CP READ", 7) != 0 &&
                      strncmp(screen(rc(24,61)), "MORE...", 7) != 0 )
                        getoutput();
                for(r=fr; r<=22; r++) {
                        l = screen(rc(r, 1));
                        if(*l == ' ' || *l == '\0')
                                break;
                        printf("%s\n", l);
                }
                fr = 1;
	} while(strncmp(screen(rc(24,61)), "MORE...", 7) == 0);
        alarm(0);
	$input data(off) enter;
}

char *lastline()
{
	char *l;
	int r;

	l = screen(rc(24,61));
        while(strncmp(l, "CP READ", 7) && strncmp(l, "MORE...", 7))
                getoutput();
	for(r=22; r>=0; r--) {
		l = screen(rc(r, 1));
		if(*l != ' ' && *l != '\0')
			break;
	}
	return(l);
}

usage()
{
	fprintf(stderr, "Usage: qprt [-u vmid] [-p password] [-f file]\n");
	exit(1);
}
