
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <ctype.h>

#define SHIFT { --argc; ++argv; }
#define VALID(c) (('0' <= c && c <= '9') || \
                  ('a' <= c && c <= 'f') || \
                  ('A' <= c && c <= 'F'))
#define XTOI(c) (('0' <= c && c <= '9') ? c - '0':\
                 ('a' <= c && c <= 'f') ? c - 'a' + 10:\
                 ('A' <= c && c <= 'F') ? c - 'A' + 10:\
                                          -1)
#define COMPOS 105
#define SHOWSIZE 368
#define HEX      16
#define DECIMAL  10
#define OCTAL    8

extern char etatab[];
extern char atetab[];
char command[32] = "";
char findcmd[32] = " ";
int backward = 0;
char bigbuf[BUFSIZ];
char *zero = "\0";
int triedtoe = 0;
int triedtoq = 0;
int changedtemp = 0;
int done = 0;
int numblock,leftover;

union {
	unsigned int i[92];
        char c[23][16];
	char c1[368];
} buffer;

int offset, curpos, changed, filesize, readonly, attr;
int  oldoffset,nread, didwrite;
int  inoffset,inlength;
int  ebcdic = 0;
char filename[16];
char type[7] = "";
char msg[9];
int origfile;             /* fd */
int tempfile;             /* fd */
int newtempfile;          /* fd */
char hexes[23] [4] [9];
char bar[23][2];
char chars[23] [17];
char count[23] [7];
struct stat statb;
char template[20] = "/tmp/hedXXXXX";
char tempname[20];
char newtempname[20];


main(argc,argv)
int argc;
char **argv;
{
	int  i, n;
        char *p;

        signal(SIGHUP,SIG_DFL);
        signal(SIGINT,SIG_DFL);
        signal(SIGQUIT,SIG_DFL);
        signal(SIGTERM,SIG_DFL);

        setbuf(stdout,NULL);
        qstrim = 0;
	SHIFT;
        readonly = 0;
	while(**argv == '-') {
		p = *argv + 1;
		while(*p) {
                         if (*p == 'r')
                               readonly = 1;
                         else if (*p == 'e') {
                               ebcdic = 1;
		               strcpy(type,"ebcdic");
                         }
                         ++p;
                }
                SHIFT;
        }
	if (!argc)
		error("usage: hed (-r) (-e) file\n");
        strcpy(filename,*argv);
        strcpy(tempname,template);
        mktemp(tempname);
        if ((tempfile = creat(tempname,0666)) < 0)
		error("cannot creat %s\n",tempname);
        if ((origfile = open(*argv,(readonly)? 0: 2)) < 0)
		error("cannot open %s\n",*argv);
	SHIFT;


	while((n = read(origfile,bigbuf,BUFSIZ)) > 0)
		write(tempfile,bigbuf,n);
        close(tempfile);
	close(origfile);
        if ((tempfile = open(tempname,2)) < 0)
		error("cannot open %s\n",tempname);

	if (fstat(tempfile,&statb) < 0)
		error("cannot stat %s\n",*argv);
	filesize = statb.st_size;


	didwrite = 0;
        offset = 0;
        strcpy(msg,"");
	curpos = COMPOS;
        while (!done) {
	        attr = (readonly)? ON: IN;
		if (offset >= filesize)
			offset = filesize-1;
		if (offset < 0)
			offset = 0;
                offset = offset - (offset % 4);
                seek(tempfile,offset,0);
	        nread = read(tempfile,buffer.c,SHOWSIZE);
                if (nread == -1)
                        error("can't read data buffer\n");
		if (nread != SHOWSIZE)
		        for (i = nread; i < SHOWSIZE; ++i)
			        buffer.c[0][i] = 0;  /* ?? */
                oldoffset = offset;
	        showscreen();
	}
        unlink(tempname);
	exit((didwrite)? 1: 0);
}

showscreen()
{
	register int i,j;
        char c, *strend();

	for (i = 0; i < 23; i++) {
		if (offset+i*16 >= filesize) {
	                sprintf(count[i],"      ");
			bar[i][0] = ' ';
		} else {
	                sprintf(count[i],"%6x",offset+i*16);
			bar[i][0] = '|';
		}
                for (j = 0; j < 4; ++j)
			if (offset+i*16+j*4 >= filesize)
	                        sprintf(hexes[i][j],"        ");
			else
	                        sprintf(hexes[i][j],"%8x",
                                                    buffer.i[i*4+j]);
                for (j = 0; j < 16; ++j)
			if (offset+i*16+j >= filesize)
				chars[i][j] = ' ';
			else {
                                c = buffer.c[i][j];
                                if (ebcdic)
                                        c = etatab[c];
				if ((c & 0x80) ||
                                    (!c)       ||
                                    (c < 0x21))
                                        chars[i][j] = ' ';
                                else
                                        chars[i][j] = c;
			}
                chars[i][16]= 0;
	}
        if (*command)
               curpos = COMPOS + strlen(command);

	panel(cursor = curpos,bell = (*(strend(msg)-1)=='?')){
#@101#==> #IN,command,31#
#@133##ON,msg,8#
#@143##ON,filename,18#
#@162##ON,type,6#
C             for (i = 0; i < 23 ; i++) {
#@100*(i+2)+1##ON,count[i],6#      \
#attr,hexes[i][0],8# \
#attr,hexes[i][1],8# \
#attr,hexes[i][2],8# \
#attr,hexes[i][3],8#          \
#ON,bar[i],1# #attr,chars[i],16# #ON,bar[i],1#
C             }
	}
	*msg = 0;
	changed = 0;
	if (!readonly) {
                for (i = 0; i < 23; ++i)
                        if (qsmod(chars[i])) {
                                modtext(i);
                                changed = 1;
                        } else
                                for (j = 0; j < 4; ++j)
                                    if (qsmod(hexes[i][j]))
                                        if (validhex(hexes[i][j])) {
                                               buffer.i[i*4+j] =
                                                    xtoi(hexes[i][j]);
                                                changed = 1;
                                        }
                                        else
                                                strcpy(msg,"bad hex");
                if (changed) {
                        changedtemp = 1;
                        seek(tempfile,offset,0);
                        write(tempfile,buffer.c,nread);
                }
	}

        processcommand();

	curpos = 100*qscrow + qsccol;

        pfkeys();

        if (curpos < 200)
                curpos = COMPOS;
	if (*(strend(msg)-1)!='?')
		*command = 0;

}

processcommand() {
        register int i,n;
	char *p;

	p = command + 19;

	while (*p == ' ')   /* qstrim == 0, do it ourselves */
		p--;
        *(p++) = 0;             /* end of command */

	if (strcmp(command,"e") == 0)
		sprintf(command,"e %s",filename);

        if (!*command)
		;
	else if (*command == '!') {
                int pid, rpid, status;

                qsclose();
                if ((pid = fork()) < 0)
                        error("cannot fork\n");
                else if (pid == 0) {
                        if (strcmp(command,"!") == 0)
                                execl("/bin/sh","sh",0);
                        else
                                execl("/bin/sh","sh","-c",command+1,0);
                        error("cannot execl /bin/sh\n");
                } else {
                        signal(SIGHUP,SIG_IGN);
                        signal(SIGINT,SIG_IGN);
                        signal(SIGQUIT,SIG_IGN);
                        signal(SIGTERM,SIG_IGN);
                        while ((rpid = wait(&status)) != pid &&
                               rpid >= 0)
                                ;
                        signal(SIGHUP,SIG_DFL);
                        signal(SIGINT,SIG_DFL);
                        signal(SIGQUIT,SIG_DFL);
                        signal(SIGTERM,SIG_DFL);
			if(strcmp(command,"!") != 0)
				for(i = 1;i <= 23;i++)
					putchar('\n');
                }
        } else if (strcmp(command,"t") == 0) {
                ebcdic = !ebcdic;
		strcpy(type,(ebcdic)? "ebcdic": "");
        } else if (strncmp(command,"e ",2) == 0) {
                if (changedtemp && !triedtoe) {
			strcpy(msg,"e?");
			triedtoe = 1;
                } else {
                        p = command+2;
                        readonly = 0;
                        while (*p == ' ')
                                ++p;
                        if (strncmp(p,"-r ",3) == 0) {
                                p += 3;
                                readonly++;
                        }
                        if ((origfile = open(p,(readonly)? 0: 2)) < 0 ||
                             fstat(origfile,&statb) < 0)
                                strcpy(msg,"?");
                        else {
                                filesize = statb.st_size;
                                strcpy(filename,p);
                                offset = 0;
                                close(tempfile);
                                tempfile = open(tempname,2);
                                while((n = read(origfile,bigbuf,BUFSIZ)) > 0)
                                        write(tempfile,bigbuf,n);
                                triedtoe = 0;
                        }
		}
        } else if (strcmp(command,"q") == 0)
                qskp = TESTREQ;
        else if (strcmp(command,"w") == 0)
                if (readonly)
                        strcpy(msg,"?");
                else {
                        strcpy(newtempname,filename);
                        strcat(newtempname,"hed");
                        if ((newtempfile =
                             creat(newtempname,0666)) < 0)
                                strcpy(msg,"?");
                        else {
                                seek(tempfile,0,0);
                                numblock = filesize / BUFSIZ;
                                leftover = filesize % BUFSIZ;
                                for(n = 0;n < numblock; n++) {
                                      read(tempfile,bigbuf,BUFSIZ);
                                      write(newtempfile,bigbuf,BUFSIZ);
                                } /* for loop */
                                read(tempfile,bigbuf,leftover);
                                write(newtempfile,bigbuf,leftover);
                                close(newtempfile);

                                sync();
                                if(link(filename,"hedlinktmp") !=0)
                                  error("can't link to %s\n",filename);
                                if(unlink(filename) != 0)
                                   error("Can't unlink %s\n",filename);
                                if (link(newtempname,filename) != 0)
                                  error("can't link to %s\n",newtempname);
                                sync();
                                if(unlink(newtempname) != 0)
                                   error("Can't unlink %s\n",newtempname);
                                if(unlink("hedlinktmp") != 0)
                                   error("Can't unlink hedlinktemp\n");
                                didwrite = 1;
                                triedtoq = 0;
                                changedtemp = 0;
                        } /* r/w file */
                }  /* command 'w' */
        else if (strncmp(command,"delete ",7) == 0) {
                p = command + 7;
	        if (validhex(p)) {
                        inoffset = xtoi(p);
                        if (inoffset > filesize)
				strcpy(msg,"?");
			else {
                                while (*p && *p != ' ')
                                      p++;
                                while (*p == ' ')
                                      p++;
                                inlength = atoi(p);
                                if (inoffset + inlength > filesize)
                                        inlength = filesize - inoffset;
                                if (readonly)
                                      strcpy(msg,"?");
                                else
                                      delete(inoffset, inlength);
                        }
                }
                else
                        strcpy(msg,"?");
        }
        else if (strncmp(command,"insert ",7) == 0) {
                p = command + 7;
	        if (validhex(p)) {
                        inoffset = xtoi(p);
                        if (inoffset > filesize)
				strcpy(msg,"?");
			else {
                                while (*p && *p != ' ')
                                      p++;
                                while (*p == ' ')
                                      p++;
                                inlength = atoi(p);
                                if (readonly)
                                      strcpy(msg,"?");
                                else
                                      insert(inoffset, inlength);
                        } /* offset <= filesize */
                }  /* valid hex */
                else
                        strcpy(msg,"?");
        } /* insert command */
        else if (strcmp(command,"$") == 0)
                offset = filesize-1;
        else if (strncmp(command,"xd ",3) == 0)
                convert(command+3,HEX,DECIMAL);
        else if (strncmp(command,"dx ",3) == 0)
                convert(command+3,DECIMAL,HEX);
        else if (strncmp(command,"xo ",3) == 0)
                convert(command+3,HEX,OCTAL);
        else if (strncmp(command,"ox ",3) == 0)
                convert(command+3,OCTAL,HEX);
        else if (strncmp(command,"do ",3) == 0)
                convert(command+3,DECIMAL,OCTAL);
        else if (strncmp(command,"od ",3) == 0)
                convert(command+3,OCTAL,DECIMAL);
        else if (*command == '-')
                offset -= xtoi(command+1);
        else if (*command == '+')
                offset += xtoi(command+1);
	else if (*command == '/') {
                backward = 0;
                if (strcmp(command,"//") == 0)
                      offset = locate(findcmd);
                else
                      offset = locate(command);
        }
	else if (*command == '?') {
                backward++;
                if (strcmp(command,"??") == 0)
                      offset = locate(findcmd);
                 else
                      offset = locate(command);
        }
	else if (validhex(command))
                offset = xtoi(command);
	else
		strcpy(msg,"?");

}
pfkeys() {

        register int n;

	switch(qskp) {
	case(PF1):
		showhelp();
                break;
	case(PF3):
                if (!readonly) {
                        strcpy(newtempname,filename);
                        strcat(newtempname,"hed");
                        if ((newtempfile =
                             creat(newtempname,0666)) < 0)
                                strcpy(msg,"?");
                        else {
                                seek(tempfile,0,0);
                                numblock = filesize / BUFSIZ;
                                leftover = filesize % BUFSIZ;
                                for(n = 0;n < numblock; n++) {
                                      read(tempfile,bigbuf,BUFSIZ);
                                      write(newtempfile,bigbuf,BUFSIZ);
                                }
                                read(tempfile,bigbuf,leftover);
                                write(newtempfile,bigbuf,leftover);
                                close(newtempfile);

                                sync();
                                if(link(filename,"hedlinktmp") !=0)
                                  error("can't link to %s\n",filename);
                                if(unlink(filename) != 0)
                                   error("Can't unlink %s\n",filename);
                                if (link(newtempname,filename) != 0)
                                  error("can't link to %s\n",newtempname);
                                sync();
                                if(unlink(newtempname) != 0)
                                   error("Can't unlink %s\n",newtempname);
                                if(unlink("hedlinktmp") != 0)
                                   error("Can't unlink hedlinktemp\n");
                                sync();
                                didwrite = 1;
                                triedtoq = 0;
                                changedtemp = 0;
                        }
                }
                done = 1;
		break;
	case(PF4):
                backward++;
		offset = locate(findcmd);
                curpos = COMPOS;
		break;
	case(PF5):
                backward = 0;
		offset = locate(findcmd);
                curpos = COMPOS;
                break;
	case(PF7):
		offset -= 12*16;
                curpos = ((curpos > 1200) ||
                          (curpos < 200))
                                 ? COMPOS
                                 : curpos + 1200;
                break;
	case(PF8):
		offset += 12*16;
                curpos = (curpos < 1200) ? COMPOS
                                         : curpos - 1200;
		break;
	case(PF10):
		offset -= 23*16;
                curpos = COMPOS;
                break;
	case(PF11):
		offset += 23*16;
                curpos = COMPOS;
		break;
	case(PF12):
		curpos = COMPOS;
		break;
	case(TESTREQ):
		if (changedtemp &&  !triedtoq) {
                        strcpy(msg,"q?");
                        triedtoq = 1;
                }
                else
                        done = 1;
		break;
	default:
		break;
	}
}

delete(inoffset,inlength)
int inoffset,inlength;
{
        register int n;

        strcpy(newtempname,template);
        mktemp(newtempname);
        if ((newtempfile = creat(newtempname,0666)) < 0)
               error("cannot creat %s\n",newtempname);
        seek(tempfile,0,0); /* old temp file */

        numblock = inoffset / BUFSIZ;
        leftover = inoffset % BUFSIZ;
        for(n = 0;n < numblock; n++) {
                read(tempfile,bigbuf,BUFSIZ);
                write(newtempfile,bigbuf,BUFSIZ);
        }
        read(tempfile,bigbuf,leftover);
        write(newtempfile,bigbuf,leftover);

        seek(tempfile,inlength,1);
        while ((n = read(tempfile,bigbuf,BUFSIZ)) > 0)
                write(newtempfile,bigbuf,n);

        filesize -= inlength;
        close(tempfile);
        close(newtempfile);
        unlink(tempname);     /* old one goes away */

        strcpy(tempname,newtempname);
        tempfile = open(tempname,2);
        changedtemp = 1;
}

insert(inoffset,inlength)
int inoffset,inlength;
{
        register int n,m;

        strcpy(newtempname,template);
        mktemp(newtempname);
        if ((newtempfile = creat(newtempname,0666)) < 0)
               error("cannot creat %s\n",newtempname);
        seek(tempfile,0,0);

        numblock = inoffset / BUFSIZ;
        leftover = inoffset % BUFSIZ;
        for(n = 0;n < numblock; n++) {
                read(tempfile,bigbuf,BUFSIZ);
                write(newtempfile,bigbuf,BUFSIZ);
        }
        read(tempfile,bigbuf,leftover);
        write(newtempfile,bigbuf,leftover);

        for(n = 0;n < inlength; n++) {
                write(newtempfile,zero,1);
        }

        while ((n = read(tempfile,bigbuf,BUFSIZ)) > 0)
                write(newtempfile,bigbuf,n);

        filesize += inlength;
        close(tempfile);
        close(newtempfile);
        unlink(tempname);     /* old one goes away */

        strcpy(tempname,newtempname);
        tempfile = open(tempname,2);
        changedtemp = 1;
}
convert(s,ib,ob)
char *s;
int ib,ob;
{
	register int i;

	while(*s == ' ')
		s++;

	i = 0;
	while(*s) {
		if (ib == 8 && '0' <= *s && *s <= '7')
			i = 8*i + *s - '0';
		else if (ib == 10 && '0' <= *s && *s <= '9')
			i = 10*i + *s - '0';
		else if (ib == 16 && '0' <= *s && *s <= '9')
			i = 16*i + *s - '0';
		else if (ib == 16 && 'a' <= *s && *s <= 'f')
			i = 16*i + *s - 'a' + 10;
		else if (ib == 16 && 'A' <= *s && *s <= 'F')
			i = 16*i + *s - 'A' + 10;
		else
                     break;
                ++s;
		}
		sprintf(msg,(ob == 8)  ? "%o" :
		            (ob == 16) ? "%x" :
                                         "%d",i);
}

modtext(i)
int i;
{                 /* i'th data changed, modify only changed data */
	register int k,j;
	char temp[21],c;

        for (j = 0; j < 16 ; ++j)
		if(chars[i][j] == 0) {
                        for (k = j; k < 16; k++) {
                                buffer.c[i][k] = 0;
                                chars[i][k] = ' ';
                        }
                        break;
                }

        for (j = 0; j < 16; ++j)
                if (offset+i*16+j >= filesize)
                        temp[j] = ' ';
                else {
                        c = buffer.c[i][j];
                        if (ebcdic)
                                c = etatab[c];
                        if ((c & 0x80) ||
                            (!c)       ||
                            (c < 0x21))
                                temp[j] = ' ';
                        else
                                temp[j] = c;
                }
        temp[16]= 0;

        for (j = 0; j < 16; ++j)
		if (temp[j] != chars[i][j])
                        buffer.c[i][j] = (ebcdic) ?
                                         atetab[chars[i][j]] :
                                         chars[i][j];
}

error(args)
int *args;
{
	fprintf(stderr,"%r",&args);
        unlink(tempname);
	exit(2);
}

locate(str)
char *str;
{
	register int n,i;
	int length,character,incr,found, ntoread,around;
	char *p;
	char c;
        char findstr[15];

        strcpy(findcmd,str);
	c = *str;
        ++str;
	p = findstr;
        while((*str) && (*str != c))
                *p++ =  *str++;
        *p = 0;                  /* end with a null */

	if (*str == '/' || *str == '?')
		 str++;
	else {
		strcpy(msg,"?");
		return(offset);
	}

        if(*str && *(str+1)) {
                strcpy(msg,"?");
                return(offset);
        }
	character = 0;
        incr = 1;
	switch(*str) {
	case(0):           /* anywhere  */
                incr = 1;
		break;
	case('c'):         /* character data */
                incr = 1;
		character++;
                if (ebcdic) {     /* convert data for character search */
			p = findstr;
	                while (*p) {
		              *p = atetab[*p];
                              *p++;
                        }
                }
		break;
	case('d'):         /* doubleword boundary */
		incr = 8;
		break;
	case('f'):         /* fullword boundary */
		incr = 4;
		break;
	case('h'):         /* halfword boundary */
		incr = 2;
		break;
	default:
		strcpy(msg,"?");
		return(offset);
		break;
	}


	if (!character) {
	        if(!validhex(findstr))
                        character = 1;
             /*  if data is not hex, assume it's character */
	        else
		        length = pack(findstr);
	}
        else
               length = strlen(findstr);

	if (backward) {
	   offset -= 4;
	   found = 0;
           around = 0;
	   while(!found) {  /* backward find */
	        if (offset == 0) {
		        offset = filesize;
                        around++;
                }
                i = offset - SHOWSIZE;
                if (i < 0) { /* beginning of file */
                        offset = 0;
                        ntoread = offset;  /* for negative case */
                } else {
                        offset = i;
			ntoread = SHOWSIZE;
                }
                seek(tempfile,offset,0);    /* to current offset */

                n = read(tempfile,buffer.c,ntoread);
	        i = index(buffer.c1,findstr,n,length);
                if (i == -1)            /* not found */
                        if ((offset <  oldoffset) &&
                            (offset + n > oldoffset))
                                found++;    /* quit */
                        else;
                else if ((offset+i)%incr == 0)    /* found it */
                        return(offset + i);
                else
                        offset = offset + i - 1;
                if (around > 1)
                        found++;
	   } /* end while not found */
        } else {    /* forward search */
	   offset += 4;
           found = 0;
	   while(!found) {
                seek(tempfile,offset,0);        /* to current offset */
                n = read(tempfile,buffer.c,SHOWSIZE);
                if (n == 0) { /* end of file */
                        seek(tempfile,0,0);
                        offset = 0;
	                n = read(tempfile,buffer.c,SHOWSIZE);
                }
	        i = index(buffer.c1,findstr,n,length);
                if (i == -1) {           /* not found */
                        if ((offset <= oldoffset) &&
                            (offset + SHOWSIZE > oldoffset))
                                found++;
                        offset += SHOWSIZE;
                } else if ((offset+i)%incr == 0)    /* found it */
                        return(offset + i);
                else
                        offset = offset + i + 1;
	   } /* end while not found */
	} /* end else not backward */

	strcpy(msg,"?");
        return(oldoffset);
}

pack(s)
char *s;
{
	char *p,*os;
	int i,j;
	p = os = s;

	while(*s) {

		i = XTOI(*s);
		++s;

		j = 0;
                if (*s) {
                        j = XTOI(*s);
			++s;
		}
                *p++ = i * 16 + j;
	}
	*p = 0;
	return(p - os);
}
validhex(s)
char *s;
{
char *os;

	while(*s == ' ')
		s++;
	os = s;
	while(*s && *s != ' ') {
                if(!VALID(*s))
                       return(0);
                s++;
	}
	return(s - os <= 8);
}

xtoi(s)
char *s;
{
	register int i;

	while(*s == ' ')
		s++;
	i = 0;
	while(*s && *s != ' ') {
                i = i * 16 + XTOI(*s);
		s++;
	}
	return(i);
}

index(s,t,ls,lt)
char *s,*t;
int ls,lt;
{
        register int i,j;
 
        for(i = 0; i < ls - lt + 1; i++)
                if (s[i] == t[0]) {
			for(j = 1; j < lt; j++)
				if (s[i+j] != t[j])
					break;
			if (j == lt)
				return(i);
		 }
         return(-1);
}

showhelp()
{
	panel() {
#@115#            Hexadecimal EDitor Help Screen

#@201#  Commands:
                  /xxxx/<c>,?xxx?<c> find hex values xxxx on some boundary
                           <c> can be d for doubleword,
                                      f for fullword,
                                      h for halfword,
                                (blank) for anywhere.
                  /xxxx/c   find xxxx in the character display area.
		  (+,-) xxxx change the display offset (modulo 4).
                  insert/delete <hexloc> <numbytes>

                  ! - exec a shell
                  $ - go to the end of the file.
                  t - translate into EBCDIC or back
                  e - (-r) filename (read-only)(just like ned).
                  xd,dx,od,do,xo,ox conversions (octal, decimal, hex)

                  PF keys are: PF1 (help), PF12(cursor to top)
                               PF4,PF5 repeat find,
                               PF7,8,10,11 scroll half,full page.
                  You may change any hex value in the display area.
                  You may change data in the character display area.

                    (HIT ENTER TO RETURN)
	}
	return;
}
