#include <stdio.h>
#include "sym.h"
#include "assem.h"
#include <signal.h>
#include <sys/times.h>
#include "numlab.h"
#include <assert.h>

/*
 * main routine for assembler
 */

char dotrel, **curarg;
char *outfile = "a.out";
char *etmp;
char *mktemp();
int dot, nargs, lineno, litstart, savdot[MAXSECTS];
int size[MAXSECTS], oseek[MAXSECTS];
int rsize[MAXSECTS], rseek[MAXSECTS];
int (*scan)(), errflg, symsiz, relsiz, entrie;
int listflg;
int symdec;
FILE *infil, *outfil;
FILE *txtfil, *litfil, *relspace;
/*
 * extremely kludgy kludge so that DSECT labels are not placed
 * in the symbol table (this thing is instead).
 */
struct symtab dum_dum = {"dum_dum", ABSOLUTE, 0, 0};

main(argc,argv)
int argc;
char **argv;{

	register int c;
	int oneflag, timeflag, quit(), nospace();
	char *s;
	struct tms tstart;

	for (c = 1; c < 4; c++)
		if (signal(c, SIG_IGN) != SIG_IGN)
			signal(c, quit);
	signal(SIGNOSPC, nospace);
	oneflag = 0;
	timeflag = 0;
	infil = stdin;
	setbuf(stdout, (char *)NULL);
	while (--argc > 0 && **++argv == '-'){
		switch(c = *(*argv+1)){
			case 'o':
				outfile = *++argv;
				--argc;
				continue;
			case 'u':
				uflag = 1;
				continue;
			case 's':
				sflag = 1;
				continue;
			case '1':
				oneflag = 1;
				continue;
			case 't':
				timeflag = 1;
				continue;
			case 'C':
				compiled = 1;
				continue;
			case 'L':
				listflg = 1;
				etmp = *++argv;
				--argc;
				/*
				 * verify that the listing is going to
				 * a ".lst" file
				 */
				s = etmp;
				while(*s)
					s++;
			        /*
				 * back up and find the '.'
				 */
				while (*s != '.')
					s--;
				s++;
				if (strcmp(s, "lst") != 0)
					error(1, "must write listing to '.lst' file");
				continue;
			default:
				printf("-%c?\n",c);
				return;
			}
		}
	nargs = argc;
	curarg = argv;
	if (nargs != 0){
		while ((infil = fopen(*curarg, "r")) == NULL){
			printf("Can't open %s\n", *curarg);
			if (--nargs <= 0) return;
			curarg++;
			}
		}
	times(&tstart);
	init();
	pass1();
	if (timeflag) prtime(1, &tstart);
	if (oneflag) exit(1);
	times(&tstart);
	if (listflg)
		opfil1();
	middle();
	curarg = argv;
	pass2();
	finishout();
	if (listflg)
		/*
		 * print listing
		 */
		prtfiles();
	if (timeflag) prtime(2, &tstart);
	quit(errflg);
	}

prtime(pass, tb)
int pass;
struct tms *tb;
{
	struct tms t_end;

	times(&t_end);
	printf("pass %d:  user = %.3f, sys = %.3f\n", pass,
		(double)(t_end.tms_utime-tb->tms_utime)/1000000.,
		(double)(t_end.tms_stime-tb->tms_stime)/1000000.);
	}

init(){
	dot = 0;
	dotrel = TEXTSEG;
	prtype = TEXTSEG;
	lineno = 1;
	if (listflg)
		opfil2();
        txtfil = memopen("text", "w");
        fbfil = memopen("numeric labels", "w");
        litfil = memopen("literals", "w");
	if (txtfil==NULL || fbfil==NULL || litfil==NULL)
		error(1, "assembler can't create temp files");
	poolp = pool;
	litstart = 0;
	fseek(litfil, (LITTYPES+2)*BPW, 0);
	scan = scan1;
	syminit();
	}

middle(){
	register int i, j;
	register char *x;

	savdot[dotrel-TEXTSEG] = dot;
	dot = 0;
	dotrel = TEXTSEG;
	prtype = TEXTSEG;
	orel = TEXTSEG;
	size[0] = align(savdot[0], BPD);
	oseek[0] = HDRSIZ;
	savdot[0] = 0;
	j = HDRSIZ+size[0];
	for (i = 3; i < 3+nsects; i++){
		if (size[i] != -1){
			size[i] = align(savdot[i], BPD);
			oseek[i] = j;
			j = j+size[i];
			}
		else oseek[i] = j;
		savdot[i] = 0;
		}
	for (i = 1; i < 3; i++){
		size[i] = align(savdot[i],BPD);
		oseek[i] = j;
		j = j+size[i];
		savdot[i] = 0;
		}
	relsiz = 0;
	if (listflg)
		closefil();
	if (errflg) quit(1);
	memreopen(txtfil, "r");
	memreopen(litfil, "r");
	if ((outfil = fopen(outfile, "w")) == NULL)
		error(1,"Can't create output");
	scan = scan2;
	fbmiddle();
	fseek(outfil, HDRSIZ, 0);
	relspace = memopen("relocation", "w");
	lineno = 1;
	for (i = 0; i < MAXUSING; i++)
		using[i].reg = -1;
	for (i = 0; i < LITTYPES; i++){
		litcount[i] = getw(litfil);
		}
	litstart = getw(litfil);
	litrel = getw(litfil);
	}

finishout(){
	register int i, j;
	register SYM *s;
	int txtsiz, dsect_flag, k;
	struct reloc bf;
	struct exec hdr;

	memreopen(relspace, "r");
	rseek[0] = oseek[2];
	j = rseek[0]+rsize[0];
	rsize[0] = 0;
	for (i = 3; i < 3+nsects; i++){
		rseek[i] = j;
		j += rsize[i];
		rsize[i] = 0;
		}
	for (i = 1; i < 3; i++){
		rseek[i] = j;
		j += rsize[i];
		rsize[i] = 0;
		}
	while ((i = getw(relspace)) != EOF){
		assert(i >= 0 && i <= 2);
		fseek(outfil, rseek[i]+rsize[i], 0);
		fread((char *)&bf, sizeof bf, 1, relspace);
		fwrite((char *)&bf, sizeof bf, 1, outfil);
		rsize[i] += sizeof bf;
		}
	fseek(outfil, rseek[2]+rsize[2], 0);
	symsiz = dumpsym();
	fseek(outfil, 0, 0);
	txtsiz = size[0];
	for (i = 3; i < 3+nsects; i++){
		if (size[i] > -1) txtsiz += size[i];
		}
	hdr.a_magic = A_MAGIC1;
	hdr.a_text = txtsiz;
	hdr.a_data = size[1];
	hdr.a_bss = size[2];
	hdr.a_syms = symsiz;
	hdr.a_entry = entrie;
	hdr.a_reloc = relsiz;
	hdr.a_flag = 0;
	fwrite((char *)&hdr, HDRSIZ, 1, outfil);
	fclose(outfil);
	}

nospace()
{
	fprintf(stderr, "Out of disk space (sig 27) - assembly terminated\n");
	quit(1);
}

genreloc(offset, len, e)
register int offset, len;
register struct exp *e;{

	struct reloc rb;
	int r, symno;

	r = e->e_type & LOCAL;
	if (r == ABSOLUTE || r >= DABS) return;
	if (e->e_type != EXTERN && e->e_type != DLINK) e->e_type &= LOCAL;
	if (e->e_symp != NULL && (e->e_type & EXTERN))
		symno = e->e_symp->s_symno;
	else symno = 0;
	rb.r_addr = offset+oseek[dotrel-TEXTSEG]-oseek[0];
	rb.r_symno = symno;
	rb.r_len = len;
	rb.r_type = e->e_type;
	putw(dotrel-TEXTSEG, relspace);
	fwrite((char *)&rb, sizeof rb, 1, relspace);
	rsize[dotrel-TEXTSEG] += sizeof rb;
	relsiz += sizeof rb;
	}
